package io.intino.consul.container.box.service.requests;

import com.google.gson.JsonElement;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.JMSException;
import jakarta.jms.Message;

import java.util.Map;

public abstract class ContainerRequest implements RequestAttendant {

	protected Map<String, JsonElement> activityParameters(Message request) throws JMSException {
		Map<String, JsonElement> parameters = parameters(request);
		parameters.remove("activity");
		return parameters;
	}

	protected String activity(Message request) throws JMSException {
		return parameters(request).get("activity").getAsString();
	}
}
