package io.intino.consul.container.box.actions;

import io.intino.alexandria.message.Message;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.framework.Activity.Context;
import io.intino.consul.framework.utils.Utils;
import io.intino.cosmos.datahub.messages.universe.ObservableAssertion.Operation;
import io.intino.cosmos.datahub.messages.universe.ObserverAssertion;

import java.util.ArrayList;
import java.util.List;

public class ObserverAssertionAction {
	private final ContainerBox box;
	private final Context context;

	public ObserverAssertionAction(ContainerBox box, Context context) {
		this.box = box;
		this.context = context;
	}

	public void execute() {
		final ObserverAssertion newInfo = observerAssertion();
		if (!hasChanges(newInfo)) return;
		if (context.terminal() != null) context.terminal().publish(newInfo);
		box.store().put("root#consulInfo", withOutTs(newInfo.toMessage()));
	}

	private ObserverAssertion observerAssertion() {
		return (ObserverAssertion) new ObserverAssertion(context.observer(), context.observer())
				.version(Utils.currentVersion())
				.installedActivities(new ArrayList<>(box.activities().activities().keySet()))
				.enabledActivities(box.activities().enabledActivities())
				.model("application.observer")
				.operationList(List.of(new Operation().name("restartService").activity(null)))
				.container(context.hostName());
	}

	private boolean hasChanges(ObserverAssertion newInfo) {
		final String last = box.store().get("root#consulInfo", String.class);
		return last == null || !withOutTs(newInfo.toMessage()).equals(last);
	}

	private String withOutTs(Message message) {
		return message.toString().replaceFirst("\nts:.*\n", "\n");
	}
}
