package io.intino.consul.container.box;

import io.intino.consul.container.box.ContainerBox;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.container.box.actions.*;
import org.quartz.*;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.time.ZoneId;
import java.io.File;
import io.intino.alexandria.logger.Logger;

import static org.quartz.JobBuilder.newJob;
import static org.quartz.CronScheduleBuilder.*;
import static org.quartz.TriggerBuilder.newTrigger;

public class Sentinels {

	private Sentinels() {

	}

	public static void init(AlexandriaScheduler scheduler, java.io.File home, ContainerBox box) {
		JobDetail job;
		try {
			job = newJob(io.intino.consul.container.box.scheduling.ComputerAssertionListener.class).withIdentity("computerAssertion").build();
			job.getJobDataMap().put("box", box);
			scheduler.scheduleJob(job, newSet(newTrigger().withIdentity("Box#computerAssertion").withSchedule(cronSchedule("0 0/15 * 1/1 * ? *")).build(), newTrigger().startAt(java.util.Date.from(java.time.Instant.now().plus(1000, java.time.temporal.ChronoUnit.MILLIS))).build()), true);
			job = newJob(io.intino.consul.container.box.scheduling.SaveStoreListener.class).withIdentity("saveStore").build();
			job.getJobDataMap().put("box", box);
			scheduler.scheduleJob(job, newSet(newTrigger().withIdentity("Box#saveStore").withSchedule(cronSchedule("0 0/15 * 1/1 * ? *")).build()), true);
			scheduler.startSchedules();
		} catch (Exception e) {
			Logger.error(e.getMessage());
		}
	}



	private static Set<Trigger> newSet(Trigger... triggers) {
		LinkedHashSet<Trigger> set = new LinkedHashSet<>();
		java.util.Collections.addAll(set, triggers);
		return set;
	}
}