/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.Properties;
import smile.base.svm.LinearKernelMachine;
import smile.base.svm.SVR;
import smile.math.kernel.BinarySparseLinearKernel;
import smile.math.kernel.LinearKernel;
import smile.math.kernel.MercerKernel;
import smile.math.kernel.SparseLinearKernel;
import smile.regression.KernelMachine;
import smile.regression.Regression;
import smile.util.SparseArray;

public class SVM {
    public static Regression<double[]> fit(double[][] x, double[] y, double eps, double C, double tol) {
        SVR<double[]> svr = new SVR<double[]>(new LinearKernel(), eps, C, tol);
        final KernelMachine<double[]> svm = svr.fit((T[])x, y);
        return new Regression<double[]>(){
            final LinearKernelMachine model;
            {
                this.model = LinearKernelMachine.of(svm);
            }

            @Override
            public double predict(double[] x) {
                return this.model.f(x);
            }
        };
    }

    public static Regression<int[]> fit(int[][] x, double[] y, final int p, double eps, double C, double tol) {
        SVR<int[]> svr = new SVR<int[]>(new BinarySparseLinearKernel(), eps, C, tol);
        final KernelMachine<int[]> svm = svr.fit((T[])x, y);
        return new Regression<int[]>(){
            final LinearKernelMachine model;
            {
                this.model = LinearKernelMachine.binary(p, svm);
            }

            @Override
            public double predict(int[] x) {
                return this.model.f(x);
            }
        };
    }

    public static Regression<SparseArray> fit(SparseArray[] x, double[] y, final int p, double eps, double C, double tol) {
        SVR<SparseArray> svr = new SVR<SparseArray>(new SparseLinearKernel(), eps, C, tol);
        final KernelMachine<SparseArray> svm = svr.fit((SparseArray[])x, y);
        return new Regression<SparseArray>(){
            final LinearKernelMachine model;
            {
                this.model = LinearKernelMachine.sparse(p, svm);
            }

            @Override
            public double predict(SparseArray x) {
                return this.model.f(x);
            }
        };
    }

    public static <T> KernelMachine<T> fit(T[] x, double[] y, MercerKernel<T> kernel, double eps, double C, double tol) {
        SVR<T> svr = new SVR<T>(kernel, eps, C, tol);
        return svr.fit(x, y);
    }

    public static Regression<double[]> fit(double[][] x, double[] y, Properties params) {
        MercerKernel<double[]> kernel = MercerKernel.of(params.getProperty("smile.svm.kernel", "linear"));
        double eps = Double.parseDouble(params.getProperty("smile.svm.epsilon", "1.0"));
        double C = Double.parseDouble(params.getProperty("smile.svm.C", "1.0"));
        double tol = Double.parseDouble(params.getProperty("smile.svm.tolerance", "1E-3"));
        if (kernel instanceof LinearKernel) {
            return SVM.fit(x, y, eps, C, tol);
        }
        return SVM.fit(x, y, kernel, eps, C, tol);
    }
}

