/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.stat;

import java.io.Serializable;
import org.apache.commons.math3.exception.InsufficientDataException;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.util.FastMath;

public class BothWaySummaryStatistics
implements StatisticalSummary,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8419769227216721345L;
    private long n = 0L;
    private double sum = 0.0;
    private double sumSquares = 0.0;
    private Max max = new Max();
    private Min min = new Min();
    private boolean removeMade = false;

    public void addValue(double d) {
        this.sum += d;
        this.sumSquares += d * d;
        ++this.n;
        if (!this.removeMade) {
            this.max.increment(d);
            this.min.increment(d);
        }
    }

    public void removeValue(double d) {
        if (this.n == 0L) {
            throw new InsufficientDataException();
        }
        this.sum -= d;
        this.sumSquares -= d * d;
        --this.n;
        this.removeMade = true;
        this.max.clear();
        this.min.clear();
    }

    @Override
    public double getMean() {
        if (this.n == 0L) {
            return 0.0;
        }
        return this.sum / (double)this.n;
    }

    @Override
    public double getVariance() {
        if (this.n == 0L) {
            return Double.NaN;
        }
        if (this.n == 1L) {
            return 0.0;
        }
        double mean = this.getMean();
        return this.sumSquares / (double)this.n - mean * mean;
    }

    @Override
    public double getStandardDeviation() {
        if (this.n == 0L) {
            return Double.NaN;
        }
        if (this.n == 1L) {
            return 0.0;
        }
        return FastMath.sqrt(this.getVariance());
    }

    @Override
    public double getMax() {
        return this.max.getResult();
    }

    @Override
    public double getMin() {
        return this.min.getResult();
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    public BothWaySummaryStatistics clone() {
        BothWaySummaryStatistics copy = new BothWaySummaryStatistics();
        copy.n = this.n;
        copy.sum = this.sum;
        copy.sumSquares = this.sumSquares;
        return copy;
    }
}

