/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.framework.utils;

import io.intino.alexandria.jmx.JMXClient;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import java.io.IOException;

public class JMXConnection
implements AutoCloseable {
    private final Activity.System.OperatingSystem os;
    private int port = 0;
    private JMXClient.JMXConnection connection;

    public static JMXConnection connection(Activity.System system, String chain) throws IOException {
        try {
            JMXConnection connection = new JMXConnection(system.operatingSystem(), chain);
            if (connection.get() == null) {
                throw new IOException("Connection null");
            }
            return connection;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXConnection(Activity.System.OperatingSystem os, String chain) {
        this.os = os;
        try {
            if (chain.contains("\u0000\u0000")) {
                String[] split = chain.split("\u0000\u0000");
                this.port = os.createConnection(Integer.parseInt(split[1]));
                this.connection = new JMXClient("localhost", this.port).connect();
            } else {
                this.connection = new JMXClient(chain).connect();
            }
        }
        catch (Exception e) {
            Logger.trace(e.getMessage());
            if (this.port != 0) {
                os.removeConnection(this.port);
            }
        }
        finally {
            if (this.connection == null && this.port != 0) {
                os.removeConnection(this.port);
            }
        }
    }

    public JMXClient.JMXConnection get() {
        return this.connection;
    }

    @Override
    public void close() {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.port != 0) {
            this.os.removeConnection(this.port);
        }
    }
}

