/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.os.remote;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.os.remote.RemoteOperatingSystem;
import io.intino.consul.container.box.os.remote.RemoteProcessRunner;
import io.intino.consul.framework.Activity;
import java.io.File;
import java.util.Arrays;

public class RemoteSystem
implements Activity.System {
    private final Session session;
    private final RemoteOperatingSystem operatingSystem;

    public RemoteSystem(String privateKey, String remoteServer, String remotePort, String remoteUser) throws Exception {
        this.session = this.createSession(privateKey, remoteServer, remotePort, remoteUser);
        this.operatingSystem = new RemoteOperatingSystem(this.session);
        Logger.info("Connected to remote system!");
    }

    @Override
    public String name() {
        try {
            return new RemoteProcessRunner(this.session).execute("hostname").trim();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return "consul-default-server";
        }
    }

    @Override
    public Activity.System.OperatingSystem operatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public Activity.System.HDD hdd() {
        try {
            String executed = new RemoteProcessRunner(this.session).execute("df -m .").trim();
            String[] values = (String[])Arrays.stream(executed.split("\n")[1].split(" ")).map(String::trim).filter(f -> !f.isEmpty()).toArray(String[]::new);
            String openFiles = new RemoteProcessRunner(this.session).execute("ulimit -n").trim();
            return new Activity.System.HDD(Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(openFiles.trim()));
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return new Activity.System.HDD(0L, 0L, 0L);
        }
    }

    @Override
    public Activity.System.RAM ram() {
        try {
            String ram = new RemoteProcessRunner(this.session).execute("free -m").trim();
            String[] values = (String[])Arrays.stream(ram.split("\n")[1].split(" ")).map(String::trim).filter(f -> !f.isEmpty()).toArray(String[]::new);
            return new Activity.System.RAM(Integer.parseInt(values[1]), Integer.parseInt(values[2]));
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return new Activity.System.RAM(0L, 0L);
        }
    }

    @Override
    public Activity.System.CPU cpu() {
        try {
            String cores = new RemoteProcessRunner(this.session).execute("cat /proc/cpuinfo | grep processor | wc -l").trim();
            String[] iostat = new RemoteProcessRunner(this.session).execute("iostat -c").trim().split("\n");
            String[] values = (String[])Arrays.stream(iostat[iostat.length - 1].split(" ")).map(String::trim).filter(f -> !f.isEmpty()).toArray(String[]::new);
            return new Activity.System.CPU(Integer.parseInt(cores), (long)Double.parseDouble(values[0]), 0.0);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return new Activity.System.CPU(0, 0L, 0.0);
        }
    }

    @Override
    public Activity.System.Network network() {
        try {
            String ip = new RemoteProcessRunner(this.session).execute("hostname -I").trim();
            if (ip.contains(" ")) {
                ip = ip.substring(0, ip.indexOf(" "));
            }
            return new Activity.System.Network(ip, null, null);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return new Activity.System.Network(null, null, null);
        }
    }

    protected Session createSession(String privateKey, String remoteServer, String remotePort, String remoteUser) throws JSchException {
        JSch jSch = new JSch();
        jSch.addIdentity(privateKey);
        jSch.setKnownHosts(new File(new File(privateKey).getAbsoluteFile(), "known_hosts").getAbsolutePath());
        Session session = jSch.getSession(remoteUser, remoteServer, Integer.parseInt(remotePort));
        session.setConfig("StrictHostKeyChecking", "no");
        session.setServerAliveInterval(30000);
        session.setConfig("PreferredAuthentications", "publickey,password");
        session.setConfig("useDNS", "no");
        session.setTimeout(60000);
        session.connect(60000);
        return session;
    }
}

