/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.os.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.os.remote.RemoteProcessRunner;
import io.intino.consul.container.box.os.remote.SftpInputStream;
import io.intino.consul.framework.Activity;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;

public class RemoteFileSystem
implements Activity.System.FileSystem,
Closeable {
    private final Session session;

    public RemoteFileSystem(Session session) {
        this.session = session;
    }

    @Override
    public boolean exists(String path) {
        try {
            String executed = new RemoteProcessRunner(this.session).execute("ls", path).trim();
            return executed.startsWith(path);
        }
        catch (Exception e) {
            Logger.error(path + ": " + e.getMessage());
            return false;
        }
    }

    @Override
    public String readFile(String path) {
        try {
            return this.read(path).toString();
        }
        catch (JSchException | SftpException e) {
            if (e.getMessage().contains("No such file")) {
                return null;
            }
            Logger.error(path + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public byte[] readFileBytes(String path) {
        try {
            return this.read(path).toByteArray();
        }
        catch (JSchException | SftpException e) {
            Logger.error(path + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public InputStream openFile(String path) {
        try {
            ChannelSftp sftp = this.openSftp();
            return new SftpInputStream(sftp.get(path), sftp);
        }
        catch (JSchException | SftpException e) {
            Logger.error(e);
            return InputStream.nullInputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream read(String path) throws JSchException, SftpException {
        ChannelSftp sftp = null;
        try {
            sftp = this.openSftp();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            sftp.get(path, stream);
            sftp.disconnect();
            ByteArrayOutputStream byteArrayOutputStream = stream;
            return byteArrayOutputStream;
        }
        finally {
            if (sftp != null) {
                sftp.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream open(String path) throws JSchException, SftpException {
        ChannelSftp sftp = null;
        try {
            sftp = this.openSftp();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            sftp.get(path, stream);
            sftp.disconnect();
            ByteArrayOutputStream byteArrayOutputStream = stream;
            return byteArrayOutputStream;
        }
        finally {
            if (sftp != null) {
                sftp.disconnect();
            }
        }
    }

    @Override
    public void writeString(String path, String content) {
        this.writeString(path, content, StandardOpenOption.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeString(String path, String content, StandardOpenOption ... options) {
        this.mkdirs(new File(path).getParent());
        ChannelSftp sftp = null;
        try {
            sftp = this.openSftp();
            OutputStream outputStream = sftp.put(path, Arrays.asList(options).contains(StandardOpenOption.APPEND) ? 2 : 0);
            outputStream.write(content.getBytes());
            outputStream.close();
        }
        catch (JSchException | SftpException | IOException e) {
            Logger.error(e.getMessage() + ". " + path);
        }
        finally {
            if (sftp != null) {
                sftp.disconnect();
            }
        }
    }

    @Override
    public void changeOwner(String path, String user, String group) {
        try {
            new RemoteProcessRunner(this.session).execute("chown", "-R", user + ":" + group, path);
        }
        catch (Exception e) {
            Logger.error(e.getMessage() + ". " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(String source, String target, CopyOption ... options) {
        ChannelSftp sftp = null;
        try {
            sftp = this.openSftp();
            sftp.put(source, target);
        }
        catch (JSchException | SftpException e) {
            Logger.error(e.getMessage() + ". source: " + source + "; target: " + target);
        }
        finally {
            if (sftp != null) {
                sftp.disconnect();
            }
        }
    }

    @Override
    public void mkdirs(String path) {
        try {
            new RemoteProcessRunner(this.session).execute("mkdir", "-p", path);
        }
        catch (Exception e) {
            Logger.error(e.getMessage() + ". " + path);
        }
    }

    @Override
    public void delete(String path) {
        try {
            new RemoteProcessRunner(this.session).execute("rm -f", path);
        }
        catch (Exception e) {
            Logger.error(path + ": " + e.getMessage());
        }
    }

    @Override
    public void deleteDirectory(String path) {
        try {
            new RemoteProcessRunner(this.session).execute("rm", "-Rf", path);
        }
        catch (Exception e) {
            Logger.error(path + ": " + e.getMessage());
        }
    }

    @Override
    public List<String> listDirectory(String path) {
        try {
            String response = new RemoteProcessRunner(this.session).execute("ls", path).trim();
            return response.lines().map(String::trim).filter(l -> !l.isEmpty() && !l.isBlank()).toList();
        }
        catch (Exception e) {
            Logger.error(path + ": " + e.getMessage());
            return List.of();
        }
    }

    private ChannelSftp openSftp() throws JSchException {
        ChannelSftp channel = (ChannelSftp)this.session.openChannel("sftp");
        channel.connect(60000);
        return channel;
    }

    @Override
    public void close() {
    }
}

