/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.resourcecleaner;

import java.lang.ref.Cleaner;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class DisposableResource
implements AutoCloseable {
    private static final Cleaner TheCleaner = Cleaner.create(r -> new Thread(r, "AlexandriaResourceCleaner"));
    private final Cleaner.Cleanable cleanable;
    private final List<Runnable> closeHandlers = new LinkedList<Runnable>();

    public static Builder whenDestroyed(Object owner) {
        return new Builder(owner);
    }

    public static DisposableResource create(Object owner, Object resource) {
        return new Builder(owner).thenClose(resource);
    }

    public static DisposableResource create(Object owner, Object resource, Runnable callback) {
        return new Builder(owner).thenClose(resource, callback);
    }

    private DisposableResource(Cleaner.Cleanable cleanable) {
        this.cleanable = cleanable;
    }

    public void addCloseHandler(Runnable closeHandler) {
        this.closeHandlers.add(Objects.requireNonNull(closeHandler));
    }

    @Override
    public void close() {
        this.cleanable.clean();
        this.closeHandlers.forEach(Runnable::run);
    }

    private static void closeResource(Object resource) {
        if (resource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)resource).close();
            }
            catch (Exception e) {
                throw new CleanException(e);
            }
        }
    }

    public static class CleanException
    extends RuntimeException {
        public CleanException(Throwable cause) {
            super(cause);
        }
    }

    public static class Builder {
        private final Object owner;

        public Builder(Object owner) {
            this.owner = Objects.requireNonNull(owner);
        }

        public DisposableResource thenClose(Object resource) {
            Objects.requireNonNull(resource);
            if (resource == this.owner) {
                throw new IllegalArgumentException("Owner and resource cannot be the same object!!");
            }
            return new DisposableResource(TheCleaner.register(this.owner, () -> DisposableResource.closeResource(resource)));
        }

        public DisposableResource thenClose(Object resource, Runnable callback) {
            Objects.requireNonNull(resource);
            if (resource == this.owner) {
                throw new IllegalArgumentException("Owner and resource cannot be the same object!!");
            }
            return new DisposableResource(TheCleaner.register(this.owner, () -> {
                DisposableResource.closeResource(resource);
                callback.run();
            }));
        }
    }
}

