/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.jmx;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import io.intino.alexandria.jmx.Description;
import io.intino.alexandria.jmx.Parameters;
import io.intino.alexandria.logger.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMX;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JMXClient {
    private static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private JMXServiceURL url = null;

    public JMXClient(String serverDirection, int port) {
        try {
            this.url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + serverDirection + ":" + port + "/jmxrmi");
        }
        catch (MalformedURLException e) {
            Logger.error(e);
        }
    }

    public JMXClient(String url) {
        try {
            this.url = new JMXServiceURL(url);
        }
        catch (MalformedURLException e) {
            Logger.error(e);
        }
    }

    public static Map<String, String> allJMXLocalURLs() {
        LinkedHashMap<String, String> set = new LinkedHashMap<String, String>();
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        for (VirtualMachineDescriptor desc : vms) {
            try {
                String connectorAddress = JMXClient.connectorAddress(desc);
                if (connectorAddress == null) continue;
                set.put(desc.displayName(), connectorAddress);
            }
            catch (AttachNotSupportedException | IOException exception) {}
        }
        return set;
    }

    public static Map<String, String> asyncAllJMXLocalURLs(int timeoutSeconds) {
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        try {
            ExecutorService service = Executors.newFixedThreadPool(vms.size());
            List futures = vms.stream().map(desc -> service.submit(() -> {
                String connectorAddress = JMXClient.connectorAddress(desc);
                return connectorAddress == null ? null : new AbstractMap.SimpleEntry<String, String>(desc.displayName(), connectorAddress);
            })).collect(Collectors.toList());
            service.shutdown();
            service.awaitTermination(timeoutSeconds, TimeUnit.SECONDS);
            return futures.stream().filter(Future::isDone).map(JMXClient::get).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (InterruptedException e) {
            Logger.error(e);
            return Map.of();
        }
    }

    private static String connectorAddress(VirtualMachineDescriptor desc) throws AttachNotSupportedException, IOException {
        VirtualMachine vm = VirtualMachine.attach(desc);
        vm.startLocalManagementAgent();
        Properties props = vm.getAgentProperties();
        return props.getProperty(CONNECTOR_ADDRESS);
    }

    private static Map.Entry<String, String> get(Future f) {
        try {
            return (Map.Entry)f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    public JMXConnection connect() throws IOException {
        if (this.url == null) {
            throw new IOException("url cannot be null");
        }
        JMXConnector connector = JMXConnectorFactory.connect(this.url, null);
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        return new JMXConnection(connection, connector);
    }

    private String parameters(MBeanOperationInfo info) {
        return Arrays.stream(info.getSignature()).map(mb -> mb.getType() + " " + mb.getName()).collect(Collectors.joining(", "));
    }

    public class JMXConnection
    implements Closeable {
        private final MBeanServerConnection connection;
        private final JMXConnector connector;
        private List<ObjectName> beans;

        JMXConnection(MBeanServerConnection connection, JMXConnector connector) {
            this.connection = connection;
            this.connector = connector;
            try {
                this.beans = new ArrayList<ObjectName>(this.connection.queryNames(null, null));
            }
            catch (IOException e) {
                Logger.error(e);
                this.beans = new ArrayList<ObjectName>();
            }
        }

        public <T> T mBean(Class<T> mbClass) {
            return this.mBean(mbClass, this.findObjectName(mbClass.getName()));
        }

        public <T> T mBean(Class<T> mbClass, ObjectName objectName) {
            if (objectName == null) {
                Logger.error("ObjectName is null");
                return null;
            }
            return JMX.isMXBeanInterface(mbClass) ? JMX.newMXBeanProxy(this.connection, objectName, mbClass, true) : JMX.newMBeanProxy(this.connection, objectName, mbClass, true);
        }

        public List<ObjectName> beans() {
            return this.beans;
        }

        public ObjectName findObjectName(String mbClass) {
            for (ObjectName bean : this.beans) {
                if (!bean.getCanonicalName().contains(mbClass)) continue;
                return bean;
            }
            return null;
        }

        public void registerNotificatorFor(String mbClass, NotificationListener listener) {
            try {
                this.connection.addNotificationListener(this.findObjectName(mbClass), listener, null, null);
            }
            catch (IOException | InstanceNotFoundException e) {
                Logger.error(e);
            }
        }

        public void removeNotificatorFor(String mbClass, NotificationListener listener) throws IOException {
            try {
                this.connection.removeNotificationListener(this.findObjectName(mbClass), listener);
            }
            catch (InstanceNotFoundException | ListenerNotFoundException e) {
                Logger.error(e);
            }
        }

        public MBeanInfo mBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            return this.connection.getMBeanInfo(objectName);
        }

        @Override
        public void close() {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }

        public List<String> attributes(ObjectName objectName) {
            ArrayList<String> attributes = new ArrayList<String>();
            try {
                for (MBeanAttributeInfo info : this.mBeanInfo(objectName).getAttributes()) {
                    Object attribute = this.connection.getAttribute(objectName, info.getName());
                    attributes.add(info.getName() + ": " + this.resolveValue(attribute, (OpenType)info.getDescriptor().getFieldValue("openType")));
                }
            }
            catch (IOException | RuntimeException | AttributeNotFoundException | InstanceNotFoundException | IntrospectionException | MBeanException | ReflectionException exception) {
                // empty catch block
            }
            return attributes;
        }

        public Map<String, String> operations(ObjectName objectName) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            try {
                MBeanOperationInfo[] mBeanOperationInfoArray = this.mBeanInfo(objectName).getOperations();
                int n = mBeanOperationInfoArray.length;
                int n2 = 0;
                if (n2 < n) {
                    MBeanOperationInfo info = mBeanOperationInfoArray[n2];
                    Descriptor descriptor = info.getDescriptor();
                    String parameters = descriptor.getFieldValue(Parameters.class.getSimpleName()).toString();
                    String description = this.description(info);
                    map.put(info.getReturnType() + " " + info.getName() + "(" + (parameters != null ? parameters : JMXClient.this.parameters(info)) + ")", description == null ? "" : description);
                    return map;
                }
            }
            catch (IOException | RuntimeException | InstanceNotFoundException | IntrospectionException | ReflectionException exception) {
                // empty catch block
            }
            return Collections.emptyMap();
        }

        public Map<MBeanOperationInfo, String> operationInfos(ObjectName objectName) {
            try {
                return Arrays.stream(this.mBeanInfo(objectName).getOperations()).collect(Collectors.toMap(operation -> operation, this::description, (a, b) -> b, LinkedHashMap::new));
            }
            catch (IOException | RuntimeException | InstanceNotFoundException | IntrospectionException | ReflectionException exception) {
                return Collections.emptyMap();
            }
        }

        private String description(MBeanOperationInfo info) {
            return info.getDescription() != null && !info.getDescription().isEmpty() ? info.getDescription() : info.getDescriptor().getFieldValue(Description.class.getSimpleName()).toString();
        }

        public Object invokeOperation(ObjectName objectName, MBeanOperationInfo info, Object[] parameters) {
            String[] signature = (String[])Arrays.stream(info.getSignature()).map(MBeanParameterInfo::getType).toArray(String[]::new);
            try {
                return this.connection.invoke(objectName, info.getName(), parameters, signature);
            }
            catch (IOException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                return null;
            }
        }

        private String resolveValue(Object attribute, OpenType openType) {
            if (attribute instanceof CompositeDataSupport) {
                return this.resolveCompositeValue((CompositeDataSupport)attribute, ((CompositeType)openType).keySet());
            }
            if (attribute != null) {
                return attribute.toString();
            }
            return "null";
        }

        private String resolveCompositeValue(CompositeDataSupport data, Collection<String> fieldNames) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String fieldName : fieldNames) {
                map.put(fieldName, data.get(fieldName));
            }
            return this.contentString(map);
        }

        private String contentString(Map<String, Object> contents) {
            StringBuilder sb = new StringBuilder("{");
            String sep = "";
            for (Map.Entry<String, Object> entry : contents.entrySet()) {
                sb.append(sep).append(entry.getKey()).append("=");
                String s = Arrays.deepToString(new Object[]{entry.getValue()});
                sb.append(s.substring(1, s.length() - 1));
                sep = ", ";
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

