/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.jms;

import java.io.File;
import java.util.concurrent.TimeUnit;

public class ConnectionConfig {
    private final String url;
    private final String user;
    private final String password;
    private final String clientId;
    private final File keyStore;
    private final File trustStore;
    private final String keyStorePassword;
    private final String trustStorePassword;
    private final long defaultTimeoutAmount;
    private final TimeUnit defaultTimeoutUnit;

    public ConnectionConfig(String url, String user, String password, String clientId) {
        this(url, user, password, clientId, null, null, null, null, -1L, TimeUnit.MINUTES);
    }

    public ConnectionConfig(String url, String user, String password, String clientId, File keyStore, File trustStore, String keyStorePassword, String trustStorePassword) {
        this(url, user, password, clientId, keyStore, trustStore, keyStorePassword, trustStorePassword, -1L, TimeUnit.MINUTES);
    }

    public ConnectionConfig(String url, String user, String password, String clientId, File keyStore, File trustStore, String keyStorePassword, String trustStorePassword, long defaultTimeoutAmount, TimeUnit defaultTimeoutUnit) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.clientId = clientId;
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePassword = trustStorePassword;
        this.defaultTimeoutAmount = defaultTimeoutAmount;
        this.defaultTimeoutUnit = defaultTimeoutUnit;
    }

    public boolean hasSSlCredentials() {
        return this.keyStore != null;
    }

    public String url() {
        return this.url;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public String clientId() {
        return this.clientId;
    }

    public File keyStore() {
        return this.keyStore;
    }

    public File trustStore() {
        return this.trustStore;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public long defaultTimeoutAmount() {
        return this.defaultTimeoutAmount;
    }

    public TimeUnit defaultTimeoutUnit() {
        return this.defaultTimeoutUnit;
    }
}

