/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.message;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import java.time.Instant;
import java.util.Objects;

public class MessageEvent
implements Event {
    private static final String TS = "ts";
    private static final String SS = "ss";
    protected final Message message;
    protected Instant ts;
    protected String ss;

    public MessageEvent(String type, String ss) {
        this.message = new Message(type);
        this.ts = Instant.now();
        this.message.set(TS, this.ts);
        this.ss = Objects.requireNonNull(ss, "ss cannot be null");
        this.message.set(SS, this.ss);
    }

    public MessageEvent(Message message) {
        this.message = message;
        this.ts = Objects.requireNonNull(message.get(TS).asInstant(), "ts cannot be null");
        this.ss = Objects.requireNonNull(message.get(SS).asString(), "ss cannot be null");
    }

    @Override
    public String type() {
        return this.message.type();
    }

    @Override
    public Instant ts() {
        return this.ts;
    }

    @Override
    public String ss() {
        return this.ss;
    }

    @Override
    public Event.Format format() {
        return Event.Format.Message;
    }

    public MessageEvent ts(Instant ts) {
        this.ts = Objects.requireNonNull(ts);
        this.message.set(TS, this.ts);
        return this;
    }

    public MessageEvent ss(String ss) {
        this.ss = Objects.requireNonNull(ss);
        this.message.set(SS, this.ss);
        return this;
    }

    public Message toMessage() {
        return this.message;
    }

    public String toString() {
        return this.message.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageEvent that = (MessageEvent)o;
        return Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.message);
    }
}

