/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file.resource;

import io.intino.alexandria.Resource;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.FileTub;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventStream;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.event.resource.ResourceHelper;
import io.intino.alexandria.event.resource.ZipFileEntryInputStream;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourceEventTub
implements Datalake.Store.Tub<ResourceEvent>,
FileTub {
    private final File zip;

    public ResourceEventTub(File zip) {
        this.zip = zip;
    }

    public String name() {
        return this.zip.getName().replace(Event.Format.Resource.extension(), "");
    }

    @Override
    public Timetag timetag() {
        return new Timetag(this.name());
    }

    @Override
    public Stream<ResourceEvent> events() {
        try {
            return EventStream.of(this.zip);
        }
        catch (IOException e) {
            Logger.error(e);
            return Stream.empty();
        }
    }

    public List<ResourceEvent> findAll(String resourceName) {
        List<ResourceEvent> list;
        String suffix = "#" + resourceName;
        ZipFile zipFile = new ZipFile(this.zip);
        try {
            list = zipFile.stream().filter(entry -> entry.getName().endsWith(suffix)).map(entry -> this.toResourceEvent(resourceName, (ZipEntry)entry, zipFile.getEntry(entry.getName() + ".metadata"), zipFile)).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error(e);
                return new ArrayList<ResourceEvent>(0);
            }
        }
        zipFile.close();
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<ResourceEvent> find(ResourceEvent.REI rei) {
        try (ZipFile zipFile = new ZipFile(this.zip);){
            ZipEntry entry = zipFile.getEntry(rei.resourceId());
            if (entry == null) {
                Optional<ResourceEvent> optional = Optional.empty();
                return optional;
            }
            ZipEntry metadata = zipFile.getEntry(entry.getName() + ".metadata");
            Optional<ResourceEvent> optional = Optional.of(this.toResourceEvent(rei.resourceName(), entry, metadata, zipFile));
            return optional;
        }
        catch (IOException e) {
            Logger.error(e);
            return Optional.empty();
        }
    }

    private ResourceEvent toResourceEvent(String resourceName, ZipEntry entry, ZipEntry metadataEntry, ZipFile zipFile) {
        Map<String, String> metadata = this.deserialize(metadataEntry, zipFile);
        Resource resource = new Resource(resourceName, () -> new ZipFileEntryInputStream(new ZipFile(this.zip), entry));
        resource.metadata().putAll(metadata);
        return ResourceEvent.of(resource);
    }

    private Map<String, String> deserialize(ZipEntry metadataEntry, ZipFile zipFile) {
        Map<String, String> map;
        block9: {
            InputStream inputStream = zipFile.getInputStream(metadataEntry);
            try {
                Map<String, String> metadata = ResourceHelper.deserializeMetadata(new String(inputStream.readAllBytes()));
                if (metadata == null) {
                    metadata = new HashMap<String, String>(0);
                }
                metadata.put("$file", this.zip.getAbsolutePath());
                map = metadata;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new HashMap<String, String>(0);
                }
            }
            inputStream.close();
        }
        return map;
    }

    @Override
    public String fileExtension() {
        return Event.Format.Resource.extension();
    }

    @Override
    public File file() {
        return this.zip;
    }
}

