/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.validation.metric.ProbabilisticClassificationMetric;

public class LogLoss
implements ProbabilisticClassificationMetric {
    private static final long serialVersionUID = 2L;
    public static final LogLoss instance = new LogLoss();

    @Override
    public double score(int[] truth, double[] probability) {
        return LogLoss.of(truth, probability);
    }

    public static double of(int[] truth, double[] probability) {
        if (truth.length != probability.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, probability.length));
        }
        int n = truth.length;
        double loss = 0.0;
        for (int i = 0; i < n; ++i) {
            if (truth[i] == 0) {
                loss -= Math.log(1.0 - probability[i]);
                continue;
            }
            if (truth[i] == 1) {
                loss -= Math.log(probability[i]);
                continue;
            }
            throw new IllegalArgumentException("LogLoss is only for binary classification. Invalid label: " + truth[i]);
        }
        return loss / (double)n;
    }

    public String toString() {
        return "LogLoss";
    }
}

