/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.data.type.StructType;
import smile.math.MathEx;
import smile.math.blas.Transpose;
import smile.math.matrix.IMatrix;
import smile.math.matrix.Matrix;
import smile.regression.LinearModel;

public class LASSO {
    private static final Logger logger = LoggerFactory.getLogger(LASSO.class);

    public static LinearModel fit(Formula formula, DataFrame data) {
        return LASSO.fit(formula, data, new Properties());
    }

    public static LinearModel fit(Formula formula, DataFrame data, Properties params) {
        double lambda = Double.parseDouble(params.getProperty("smile.lasso.lambda", "1"));
        double tol = Double.parseDouble(params.getProperty("smile.lasso.tolerance", "1E-4"));
        int maxIter = Integer.parseInt(params.getProperty("smile.lasso.iterations", "1000"));
        return LASSO.fit(formula, data, lambda, tol, maxIter);
    }

    public static LinearModel fit(Formula formula, DataFrame data, double lambda) {
        return LASSO.fit(formula, data, lambda, 1.0E-4, 1000);
    }

    public static LinearModel fit(Formula formula, DataFrame data, double lambda, double tol, int maxIter) {
        formula = formula.expand(data.schema());
        StructType schema = formula.bind(data.schema());
        Matrix X = formula.matrix(data, false);
        double[] y = formula.y(data).toDoubleArray();
        double[] center = X.colMeans();
        double[] scale = X.colSds();
        for (int j = 0; j < scale.length; ++j) {
            if (!MathEx.isZero(scale[j])) continue;
            throw new IllegalArgumentException(String.format("The column '%s' is constant", X.colName(j)));
        }
        Matrix scaledX = X.scale(center, scale);
        double[] w = LASSO.train(scaledX, y, lambda, tol, maxIter);
        int p = w.length;
        for (int j = 0; j < p; ++j) {
            int n = j;
            w[n] = w[n] / scale[j];
        }
        double b = MathEx.mean(y) - MathEx.dot(w, center);
        return new LinearModel(formula, schema, X, y, w, b);
    }

    static double[] train(Matrix x, double[] y, double lambda, double tol, int maxIter) {
        int ntiter;
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid shrinkage/regularization parameter lambda = " + lambda);
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int MU = 2;
        double ALPHA = 0.01;
        double BETA = 0.5;
        int MAX_LS_ITER = 100;
        int pcgmaxi = 5000;
        double eta = 0.001;
        int pitr = 0;
        int n = x.nrow();
        int p = x.ncol();
        double[] Y = new double[n];
        double ym = MathEx.mean(y);
        for (int i = 0; i < n; ++i) {
            Y[i] = y[i] - ym;
        }
        double t2 = Math.min(Math.max(1.0, 1.0 / lambda), (double)(2 * p) / 0.001);
        double dobj = Double.NEGATIVE_INFINITY;
        double s = Double.POSITIVE_INFINITY;
        double[] w = new double[p];
        double[] u = new double[p];
        double[] z = new double[n];
        double[][] f = new double[2][p];
        Arrays.fill(u, 1.0);
        for (int i = 0; i < p; ++i) {
            f[0][i] = w[i] - u[i];
            f[1][i] = -w[i] - u[i];
        }
        double[] neww = new double[p];
        double[] newu = new double[p];
        double[] newz = new double[n];
        double[][] newf = new double[2][p];
        double[] dx = new double[p];
        double[] du = new double[p];
        double[] dxu = new double[2 * p];
        double[] grad = new double[2 * p];
        double[] diagxtx = new double[p];
        Arrays.fill(diagxtx, 2.0);
        double[] nu = new double[n];
        double[] xnu = new double[p];
        double[] q1 = new double[p];
        double[] q2 = new double[p];
        double[] d1 = new double[p];
        double[] d2 = new double[p];
        double[][] gradphi = new double[2][p];
        double[] prb = new double[p];
        double[] prs = new double[p];
        PCG pcg = new PCG(x, d1, d2, prb, prs);
        for (ntiter = 0; ntiter <= maxIter; ++ntiter) {
            int lsiter;
            double error;
            int i;
            double gap;
            x.mv(w, z);
            for (int i2 = 0; i2 < n; ++i2) {
                int n2 = i2;
                z[n2] = z[n2] - Y[i2];
                nu[i2] = 2.0 * z[i2];
            }
            x.tv(nu, xnu);
            double maxXnu = MathEx.normInf(xnu);
            if (maxXnu > lambda) {
                double lnu = lambda / maxXnu;
                int i3 = 0;
                while (i3 < n) {
                    int n3 = i3++;
                    nu[n3] = nu[n3] * lnu;
                }
            }
            double pobj = MathEx.dot(z, z) + lambda * MathEx.norm1(w);
            dobj = Math.max(-0.25 * MathEx.dot(nu, nu) - MathEx.dot(nu, Y), dobj);
            if (ntiter % 10 == 0) {
                logger.info(String.format("LASSO: primal and dual objective function value after %3d iterations: %.5g\t%.5g%n", ntiter, pobj, dobj));
            }
            if ((gap = pobj - dobj) / dobj < tol) {
                logger.info(String.format("LASSO: primal and dual objective function value after %3d iterations: %.5g\t%.5g%n", ntiter, pobj, dobj));
                break;
            }
            if (s >= 0.5) {
                t2 = Math.max(Math.min((double)(2 * p * 2) / gap, 2.0 * t2), t2);
            }
            for (i = 0; i < p; ++i) {
                double q1i = 1.0 / (u[i] + w[i]);
                double q2i = 1.0 / (u[i] - w[i]);
                q1[i] = q1i;
                q2[i] = q2i;
                d1[i] = (q1i * q1i + q2i * q2i) / t2;
                d2[i] = (q1i * q1i - q2i * q2i) / t2;
            }
            x.tv(z, gradphi[0]);
            for (i = 0; i < p; ++i) {
                gradphi[0][i] = 2.0 * gradphi[0][i] - (q1[i] - q2[i]) / t2;
                gradphi[1][i] = lambda - (q1[i] + q2[i]) / t2;
                grad[i] = -gradphi[0][i];
                grad[i + p] = -gradphi[1][i];
            }
            for (i = 0; i < p; ++i) {
                prb[i] = diagxtx[i] + d1[i];
                prs[i] = prb[i] * d1[i] - d2[i] * d2[i];
            }
            double normg = MathEx.norm(grad);
            double pcgtol = Math.min(0.1, 0.001 * gap / Math.min(1.0, normg));
            if (ntiter != 0 && pitr == 0) {
                pcgtol *= 0.1;
            }
            if ((error = pcg.solve(grad, dxu, pcg, pcgtol, 1, 5000)) > pcgtol) {
                pitr = 5000;
            }
            for (int i4 = 0; i4 < p; ++i4) {
                dx[i4] = dxu[i4];
                du[i4] = dxu[i4 + p];
            }
            double phi = MathEx.dot(z, z) + lambda * MathEx.sum(u) - LASSO.sumlogneg(f) / t2;
            s = 1.0;
            double gdx = MathEx.dot(grad, dxu);
            for (lsiter = 0; lsiter < 100; ++lsiter) {
                int i5;
                for (i5 = 0; i5 < p; ++i5) {
                    neww[i5] = w[i5] + s * dx[i5];
                    newu[i5] = u[i5] + s * du[i5];
                    newf[0][i5] = neww[i5] - newu[i5];
                    newf[1][i5] = -neww[i5] - newu[i5];
                }
                if (MathEx.max(newf) < 0.0) {
                    x.mv(neww, newz);
                    for (i5 = 0; i5 < n; ++i5) {
                        int n4 = i5;
                        newz[n4] = newz[n4] - Y[i5];
                    }
                    double newphi = MathEx.dot(newz, newz) + lambda * MathEx.sum(newu) - LASSO.sumlogneg(newf) / t2;
                    if (newphi - phi <= 0.01 * s * gdx) break;
                }
                s = 0.5 * s;
            }
            if (lsiter == 100) {
                logger.error("LASSO: Too many iterations of line search.");
                break;
            }
            System.arraycopy(neww, 0, w, 0, p);
            System.arraycopy(newu, 0, u, 0, p);
            System.arraycopy(newf[0], 0, f[0], 0, p);
            System.arraycopy(newf[1], 0, f[1], 0, p);
        }
        if (ntiter == maxIter) {
            logger.error("LASSO: Too many iterations.");
        }
        return w;
    }

    private static double sumlogneg(double[][] f) {
        double sum = 0.0;
        double[][] dArray = f;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double x : row = dArray[i]) {
                sum += Math.log(-x);
            }
        }
        return sum;
    }

    static class PCG
    extends IMatrix
    implements IMatrix.Preconditioner {
        Matrix A;
        Matrix AtA;
        int p;
        double[] d1;
        double[] d2;
        double[] prb;
        double[] prs;
        double[] ax;
        double[] atax;

        PCG(Matrix A, double[] d1, double[] d2, double[] prb, double[] prs) {
            this.A = A;
            this.d1 = d1;
            this.d2 = d2;
            this.prb = prb;
            this.prs = prs;
            int n = A.nrow();
            this.p = A.ncol();
            this.ax = new double[n];
            this.atax = new double[this.p];
            if (A.ncol() < 10000) {
                this.AtA = A.ata();
            }
        }

        @Override
        public int nrow() {
            return 2 * this.p;
        }

        @Override
        public int ncol() {
            return 2 * this.p;
        }

        @Override
        public long size() {
            return this.A.size();
        }

        @Override
        public void mv(double[] x, double[] y) {
            if (this.AtA != null) {
                this.AtA.mv(x, this.atax);
            } else {
                this.A.mv(x, this.ax);
                this.A.tv(this.ax, this.atax);
            }
            for (int i = 0; i < this.p; ++i) {
                y[i] = 2.0 * this.atax[i] + this.d1[i] * x[i] + this.d2[i] * x[i + this.p];
                y[i + this.p] = this.d2[i] * x[i] + this.d1[i] * x[i + this.p];
            }
        }

        @Override
        public void tv(double[] x, double[] y) {
            this.mv(x, y);
        }

        @Override
        public void asolve(double[] b, double[] x) {
            for (int i = 0; i < this.p; ++i) {
                x[i] = (this.d1[i] * b[i] - this.d2[i] * b[i + this.p]) / this.prs[i];
                x[i + this.p] = (-this.d2[i] * b[i] + this.prb[i] * b[i + this.p]) / this.prs[i];
            }
        }

        @Override
        public void mv(Transpose trans, double alpha, double[] x, double beta, double[] y) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void mv(double[] work, int inputOffset, int outputOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void tv(double[] work, int inputOffset, int outputOffset) {
            throw new UnsupportedOperationException();
        }
    }
}

