/*
 * Decompiled with CFR 0.152.
 */
package smile.data.transform;

import java.io.Serializable;
import java.util.function.Function;
import smile.data.DataFrame;
import smile.data.Tuple;

public interface Transform
extends Function<Tuple, Tuple>,
Serializable {
    @SafeVarargs
    public static Transform fit(DataFrame data, Function<DataFrame, Transform> ... trainers) {
        Transform pipeline = trainers[0].apply(data);
        for (int i = 1; i < trainers.length; ++i) {
            data = pipeline.apply(data);
            pipeline = pipeline.andThen(trainers[i].apply(data));
        }
        return pipeline;
    }

    public static Transform pipeline(Transform ... transforms) {
        Transform pipeline = transforms[0];
        for (int i = 1; i < transforms.length; ++i) {
            pipeline = pipeline.andThen(transforms[i]);
        }
        return pipeline;
    }

    @Override
    default public DataFrame apply(DataFrame data) {
        return data.stream().map(this).collect(DataFrame.Collectors.collect());
    }

    default public Transform andThen(Transform after) {
        return t2 -> (Tuple)after.apply((Tuple)this.apply(t2));
    }

    default public Transform compose(Transform before) {
        return t2 -> (Tuple)this.apply((Tuple)before.apply(t2));
    }
}

