/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.util.Properties;
import smile.base.rbf.RBF;
import smile.classification.AbstractClassifier;
import smile.classification.ClassLabels;
import smile.math.MathEx;
import smile.math.matrix.Matrix;
import smile.util.IntSet;

public class RBFNetwork<T>
extends AbstractClassifier<T> {
    private static final long serialVersionUID = 2L;
    private final int k;
    private final Matrix w;
    private final RBF<T>[] rbf;
    private final boolean normalized;

    public RBFNetwork(int k, RBF<T>[] rbf, Matrix w, boolean normalized) {
        this(k, rbf, w, normalized, IntSet.of(k));
    }

    public RBFNetwork(int k, RBF<T>[] rbf, Matrix w, boolean normalized, IntSet labels) {
        super(labels);
        this.k = k;
        this.rbf = rbf;
        this.w = w;
        this.normalized = normalized;
    }

    public static <T> RBFNetwork<T> fit(T[] x, int[] y, RBF<T>[] rbf) {
        return RBFNetwork.fit(x, y, rbf, false);
    }

    public static <T> RBFNetwork<T> fit(T[] x, int[] y, RBF<T>[] rbf, boolean normalized) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        ClassLabels codec = ClassLabels.fit(y);
        int k = codec.k;
        int n = x.length;
        int m = rbf.length;
        Matrix G = new Matrix(n, m + 1);
        Matrix b = new Matrix(n, k);
        for (int i = 0; i < n; ++i) {
            double sum = 0.0;
            for (int j = 0; j < m; ++j) {
                double r = rbf[j].f(x[i]);
                G.set(i, j, r);
                sum += r;
            }
            G.set(i, m, 1.0);
            if (normalized) {
                b.set(i, codec.y[i], sum);
                continue;
            }
            b.set(i, codec.y[i], 1.0);
        }
        Matrix.QR qr = G.qr(true);
        qr.solve(b);
        return new RBFNetwork<T>(k, rbf, b.submatrix(0, 0, m, k - 1), normalized, codec.classes);
    }

    public static RBFNetwork<double[]> fit(double[][] x, int[] y, Properties params) {
        int neurons = Integer.parseInt(params.getProperty("smile.rbf.neurons", "30"));
        boolean normalize = Boolean.parseBoolean(params.getProperty("smile.rbf.normalize", "false"));
        return RBFNetwork.fit(x, y, RBF.fit(x, neurons), normalize);
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    @Override
    public int predict(T x) {
        int m = this.rbf.length;
        double[] f = new double[m + 1];
        f[m] = 1.0;
        for (int i = 0; i < m; ++i) {
            f[i] = this.rbf[i].f(x);
        }
        double[] sumw = new double[this.k];
        this.w.tv(f, sumw);
        return this.classes.valueOf(MathEx.whichMax(sumw));
    }
}

