/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import ro.hasna.ts.math.exception.ArrayLengthIsNotDivisibleException;
import ro.hasna.ts.math.exception.ArrayLengthIsTooSmallException;
import ro.hasna.ts.math.representation.GenericTransformer;
import ro.hasna.ts.math.type.MeanSlopePair;

public class PiecewiseLinearAggregateApproximation
implements GenericTransformer<double[], MeanSlopePair[]> {
    private static final long serialVersionUID = -4073250977010141095L;
    private final int segments;

    public PiecewiseLinearAggregateApproximation(int segments) {
        if (segments < 1) {
            throw new NumberIsTooSmallException(segments, (Number)1, true);
        }
        this.segments = segments;
    }

    @Override
    public MeanSlopePair[] transform(double[] values) {
        int len = values.length;
        if (len < this.segments) {
            throw new ArrayLengthIsTooSmallException(len, (Number)this.segments, true);
        }
        int modulo = len % this.segments;
        if (modulo != 0) {
            throw new ArrayLengthIsNotDivisibleException(len, this.segments);
        }
        MeanSlopePair[] reducedValues = new MeanSlopePair[this.segments];
        int segmentSize = len / this.segments;
        double[] x = new double[segmentSize];
        for (int i = 0; i < segmentSize; ++i) {
            x[i] = i + 1;
        }
        double variance = new Variance(true).evaluate(x);
        for (int i = 0; i < this.segments; ++i) {
            double[] y = new double[segmentSize];
            System.arraycopy(values, i * segmentSize, y, 0, segmentSize);
            double covariance = new Covariance().covariance(x, y, true);
            double mean = new Mean().evaluate(y);
            reducedValues[i] = new MeanSlopePair(mean, covariance / variance);
        }
        return reducedValues;
    }
}

