/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.filters;

import io.intino.sumus.chronos.Filter;
import io.intino.sumus.chronos.Magnitude;

public class Differential
implements Filter {
    @Override
    public double[] calculate(double[] values) {
        double[] result = Magnitude.NaN(values.length);
        int a = this.next(values, 0);
        int b = this.next(values, a + 1);
        while (b < values.length) {
            double value = this.calculate(values[a], values[b]);
            result[b] = this.mod(a + 1, b, value, result);
            a = b;
            b = this.next(values, a + 1);
        }
        return result;
    }

    protected double calculate(double a, double b) {
        return b - a;
    }

    private int next(double[] values, int i) {
        while (i < values.length && Double.isNaN(values[i])) {
            ++i;
        }
        return i;
    }

    private double mod(int a, int b, double value, double[] result) {
        if (a == b) {
            return value;
        }
        int size = b - a + 1;
        double v = value / (double)size;
        for (int i = a; i < b; ++i) {
            result[i] = v;
        }
        return v;
    }
}

