/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Magnitude;
import java.util.Arrays;

public class MeasurementBuffer {
    public static final int INITIAL_CAPACITY = 16;
    private final Magnitude magnitude;
    private double[] measurements;
    private int size;

    public MeasurementBuffer(Magnitude magnitude) {
        this(magnitude, 16);
    }

    public MeasurementBuffer(Magnitude magnitude, int initialCapacity) {
        this.magnitude = magnitude;
        this.measurements = new double[initialCapacity];
    }

    public Magnitude magnitude() {
        return this.magnitude;
    }

    public MeasurementBuffer add(double measurement) {
        if (this.size >= this.measurements.length) {
            this.resize();
        }
        this.measurements[this.size++] = measurement;
        return this;
    }

    public double reduce() {
        return this.reduce(this.magnitude.operator());
    }

    public double reduce(Magnitude.Model.Operator operator) {
        return operator.reduce(this.measurements);
    }

    public double[] toArray() {
        return this.measurements;
    }

    private void resize() {
        this.measurements = Arrays.copyOf(this.measurements, this.measurements.length * 2);
    }
}

