/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Format {
    public String format(double var1);

    public static Format of(String pattern) {
        return pattern == null || pattern.startsWith("%") ? new StringFormatter(pattern) : new CategoryFormatter(pattern);
    }

    public static class Range {
        private final double low;
        private final double high;
        private final boolean lowClosed;
        private final boolean highClosed;

        public Range(double[] values, boolean lowClosed, boolean highClosed) {
            this.low = values[0];
            this.high = values[1];
            this.lowClosed = lowClosed;
            this.highClosed = highClosed;
        }

        public static Range of(String definition) {
            return new Range(Range.values(definition), Range.isLowClosed(definition), Range.isHighClosed(definition));
        }

        private static boolean isHighClosed(String definition) {
            return definition.endsWith("]");
        }

        private static boolean isLowClosed(String definition) {
            return definition.startsWith("[");
        }

        private static double[] values(String definition) {
            try {
                return Arrays.stream(Range.split(definition)).mapToDouble(Double::parseDouble).toArray();
            }
            catch (NumberFormatException e) {
                return new double[]{Double.NaN, Double.NaN};
            }
        }

        private static String[] split(String definition) {
            return definition.replaceAll("[\\[\\]()]", "").split("\\.\\.");
        }

        public boolean matches(double value) {
            return this.matchesLow(value) && this.matchesHigh(value);
        }

        private boolean matchesHigh(double value) {
            return this.highClosed ? value <= this.high : value < this.high;
        }

        private boolean matchesLow(double value) {
            return this.lowClosed ? value >= this.low : value > this.low;
        }
    }

    public static class CategoryFormatter
    implements Format {
        private final List<Function<Double, String>> functions;

        public CategoryFormatter(String pattern) {
            this(pattern.split(","));
        }

        private CategoryFormatter(String[] categories) {
            this.functions = Arrays.stream(categories).map(this::parse).collect(Collectors.toList());
        }

        private Function<Double, String> parse(String category) {
            return this.parse(category.split(" "));
        }

        private Function<Double, String> parse(String[] split) {
            try {
                return CategoryFormatter.asNumber(split);
            }
            catch (NumberFormatException e) {
                return this.asRange(split);
            }
        }

        private Function<Double, String> asRange(String[] split) {
            Range range = Range.of(split[1]);
            return v -> range.matches((double)v) ? split[0] : null;
        }

        private static Function<Double, String> asNumber(String[] split) {
            double value = Double.parseDouble(split[1]);
            return v -> v == value ? split[0] : null;
        }

        @Override
        public String format(double value) {
            return this.functions.stream().map(f -> (String)f.apply(value)).filter(Objects::nonNull).findFirst().orElse(CategoryFormatter.defaultFormatOf(value));
        }

        private static String defaultFormatOf(double value) {
            return String.format("%,.2f", value).replace(",00", "");
        }
    }

    public static class StringFormatter
    implements Format {
        private final String pattern;

        public StringFormatter(String pattern) {
            this.pattern = pattern != null ? pattern : "%,.2f";
        }

        @Override
        public String format(double value) {
            return String.format(this.pattern, value);
        }
    }
}

