/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.Message;
import java.util.Map;

public class ActivitiesRequest
extends ContainerRequest {
    public static final String ID = "activities";
    private final ContainerBox box;

    public ActivitiesRequest(ContainerBox box) {
        this.box = box;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        Map<String, Boolean> activities = this.box.activities().activities();
        return new RequestAttendant.RequestResult(true, activities.entrySet().stream().map(e -> new Activity((String)e.getKey(), this.nameOf((String)e.getKey()), (Boolean)e.getValue())).toList());
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }

    private String nameOf(String key) {
        return key.split(":")[1];
    }

    public record Activity(String id, String name, boolean enabled) {
    }
}

