/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.jms;

import io.intino.alexandria.logger.Logger;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;

public abstract class JmsProducer {
    protected final Session session;
    private final Destination destination;
    private final int messageExpirationSeconds;
    private MessageProducer producer = null;

    public JmsProducer(Session session, Destination destination) {
        this(session, destination, 0);
    }

    public JmsProducer(Session session, Destination destination, int messageExpirationSeconds) {
        this.session = session;
        this.destination = destination;
        this.messageExpirationSeconds = messageExpirationSeconds;
        this.instanceProducer();
    }

    public boolean produce(Message message) {
        try {
            if (this.isClosed()) {
                this.instanceProducer();
            }
            this.producer.send(message);
            return true;
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    public boolean produce(Message message, int messageExpirationSeconds) {
        try {
            this.producer.send(message, 1, 4, (long)messageExpirationSeconds * 1000L);
            return true;
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    public void close() {
        if (this.producer != null) {
            try {
                this.producer.close();
                this.producer = null;
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    private void instanceProducer() {
        try {
            this.producer = this.session.createProducer(this.destination);
            this.producer.setTimeToLive((long)this.messageExpirationSeconds * 1000L);
            this.producer.setDeliveryMode(1);
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    public boolean isClosed() {
        return this.producer == null;
    }
}

