/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.measurement;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class MeasurementEvent
implements Event {
    public static final String MAGNITUDE_SEP = "\u0000";
    public static final String ATTRIBUTE_SEP = ";";
    public static final String NAME_VALUE_SEP = "=";
    protected final String type;
    protected final String source;
    protected final Instant ts;
    protected final Magnitude[] magnitudes;
    protected final double[] values;

    public MeasurementEvent(String type, String source, Instant ts, String[] magnitudes, double[] values) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.source = Objects.requireNonNull(source, "source cannot be null");
        this.ts = Objects.requireNonNull(ts, "ts cannot be null");
        this.magnitudes = this.loadMagnitudes(magnitudes);
        this.values = values;
    }

    public MeasurementEvent(String type, String source, Instant ts, Magnitude[] magnitudes, double[] values) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.source = Objects.requireNonNull(source, "source cannot be null");
        this.ts = Objects.requireNonNull(ts, "ts cannot be null");
        this.magnitudes = magnitudes;
        this.values = values;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public Instant ts() {
        return this.ts;
    }

    @Override
    public String ss() {
        return this.source;
    }

    public Magnitude[] magnitudes() {
        return this.magnitudes;
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public Event.Format format() {
        return Event.Format.Measurement;
    }

    private Magnitude[] loadMagnitudes(String[] magnitudes) {
        return (Magnitude[])Arrays.stream(magnitudes).map(m -> m.split(ATTRIBUTE_SEP)).map(fs -> new Magnitude(fs[0], ((String[])fs).length > 1 ? this.attributesOf((String[])fs) : new Magnitude.Attribute[]{})).toArray(Magnitude[]::new);
    }

    private Magnitude.Attribute[] attributesOf(String[] fs) {
        return (Magnitude.Attribute[])Arrays.stream(fs).skip(1L).map(f -> new Magnitude.Attribute(f.split(NAME_VALUE_SEP))).toArray(Magnitude.Attribute[]::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementEvent that = (MeasurementEvent)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.source, that.source) && Objects.equals(this.ts, that.ts);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.source, this.ts);
    }

    public String toString() {
        Message message = new Message(this.type());
        message.set("ss", this.ss());
        message.set("ts", this.ts());
        message.set("magnitudes", Arrays.stream(this.magnitudes).map(Magnitude::toString).collect(Collectors.toList()));
        message.set("values", this.values);
        return message.toString();
    }

    public static class Magnitude {
        private final String name;
        private final Attribute[] attributes;

        public Magnitude(String name, Attribute[] attributes) {
            this.name = name;
            this.attributes = attributes;
        }

        public String name() {
            return this.name;
        }

        public Attribute[] attributes() {
            return this.attributes;
        }

        public String toString() {
            String attributes = Arrays.stream(this.attributes).map(Attribute::toString).collect(Collectors.joining(MeasurementEvent.ATTRIBUTE_SEP));
            return this.name + (String)(this.attributes.length > 0 ? MeasurementEvent.ATTRIBUTE_SEP + attributes : "");
        }

        public static class Attribute {
            public final String name;
            public final String value;

            public Attribute(String[] nameValue) {
                this.name = nameValue[0];
                this.value = nameValue.length > 1 ? nameValue[1] : null;
            }

            public String name() {
                return this.name;
            }

            public String value() {
                return this.value;
            }

            public String toString() {
                return this.name + MeasurementEvent.NAME_VALUE_SEP + this.value;
            }
        }
    }
}

