/*
 * Decompiled with CFR 0.152.
 */
package smile.math.blas;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.IntPointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.blas.Diag;
import smile.math.blas.EVDJob;
import smile.math.blas.EigenRange;
import smile.math.blas.Layout;
import smile.math.blas.SVDJob;
import smile.math.blas.Side;
import smile.math.blas.Transpose;
import smile.math.blas.UPLO;
import smile.math.blas.openblas.OpenBLAS;

public interface LAPACK {
    public static final LAPACK engine = LAPACK.getInstance();

    public static LAPACK getInstance() {
        LAPACK mkl = LAPACK.MKL();
        return mkl != null ? mkl : new OpenBLAS();
    }

    public static LAPACK MKL() {
        Logger logger = LoggerFactory.getLogger(LAPACK.class);
        try {
            Class<?> clazz = Class.forName("smile.math.blas.mkl.MKL");
            logger.info("smile-mkl module is available.");
            return (LAPACK)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.debug("Failed to create MKL instance: ", e);
            return null;
        }
    }

    public int gesv(Layout var1, int var2, int var3, double[] var4, int var5, int[] var6, double[] var7, int var8);

    public int gesv(Layout var1, int var2, int var3, DoubleBuffer var4, int var5, IntBuffer var6, DoubleBuffer var7, int var8);

    public int gesv(Layout var1, int var2, int var3, DoublePointer var4, int var5, IntPointer var6, DoublePointer var7, int var8);

    public int gesv(Layout var1, int var2, int var3, float[] var4, int var5, int[] var6, float[] var7, int var8);

    public int gesv(Layout var1, int var2, int var3, FloatBuffer var4, int var5, IntBuffer var6, FloatBuffer var7, int var8);

    public int sysv(Layout var1, UPLO var2, int var3, int var4, double[] var5, int var6, int[] var7, double[] var8, int var9);

    public int sysv(Layout var1, UPLO var2, int var3, int var4, DoubleBuffer var5, int var6, IntBuffer var7, DoubleBuffer var8, int var9);

    public int sysv(Layout var1, UPLO var2, int var3, int var4, DoublePointer var5, int var6, IntPointer var7, DoublePointer var8, int var9);

    public int sysv(Layout var1, UPLO var2, int var3, int var4, float[] var5, int var6, int[] var7, float[] var8, int var9);

    public int sysv(Layout var1, UPLO var2, int var3, int var4, FloatBuffer var5, int var6, IntBuffer var7, FloatBuffer var8, int var9);

    public int spsv(Layout var1, UPLO var2, int var3, int var4, double[] var5, int[] var6, double[] var7, int var8);

    public int spsv(Layout var1, UPLO var2, int var3, int var4, DoubleBuffer var5, IntBuffer var6, DoubleBuffer var7, int var8);

    public int spsv(Layout var1, UPLO var2, int var3, int var4, float[] var5, int[] var6, float[] var7, int var8);

    public int spsv(Layout var1, UPLO var2, int var3, int var4, FloatBuffer var5, IntBuffer var6, FloatBuffer var7, int var8);

    public int posv(Layout var1, UPLO var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8);

    public int posv(Layout var1, UPLO var2, int var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7, int var8);

    public int posv(Layout var1, UPLO var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8);

    public int posv(Layout var1, UPLO var2, int var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7, int var8);

    public int ppsv(Layout var1, UPLO var2, int var3, int var4, double[] var5, double[] var6, int var7);

    public int ppsv(Layout var1, UPLO var2, int var3, int var4, DoubleBuffer var5, DoubleBuffer var6, int var7);

    public int ppsv(Layout var1, UPLO var2, int var3, int var4, float[] var5, float[] var6, int var7);

    public int ppsv(Layout var1, UPLO var2, int var3, int var4, FloatBuffer var5, FloatBuffer var6, int var7);

    public int gbsv(Layout var1, int var2, int var3, int var4, int var5, double[] var6, int var7, int[] var8, double[] var9, int var10);

    public int gbsv(Layout var1, int var2, int var3, int var4, int var5, DoubleBuffer var6, int var7, IntBuffer var8, DoubleBuffer var9, int var10);

    public int gbsv(Layout var1, int var2, int var3, int var4, int var5, float[] var6, int var7, int[] var8, float[] var9, int var10);

    public int gbsv(Layout var1, int var2, int var3, int var4, int var5, FloatBuffer var6, int var7, IntBuffer var8, FloatBuffer var9, int var10);

    public int gels(Layout var1, Transpose var2, int var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9);

    public int gels(Layout var1, Transpose var2, int var3, int var4, int var5, DoubleBuffer var6, int var7, DoubleBuffer var8, int var9);

    public int gels(Layout var1, Transpose var2, int var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9);

    public int gels(Layout var1, Transpose var2, int var3, int var4, int var5, FloatBuffer var6, int var7, FloatBuffer var8, int var9);

    public int gelsy(Layout var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, int[] var9, double var10, int[] var12);

    public int gelsy(Layout var1, int var2, int var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7, int var8, IntBuffer var9, double var10, IntBuffer var12);

    public int gelsy(Layout var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, int[] var9, float var10, int[] var11);

    public int gelsy(Layout var1, int var2, int var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7, int var8, IntBuffer var9, float var10, IntBuffer var11);

    public int gelss(Layout var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, double var10, int[] var12);

    public int gelss(Layout var1, int var2, int var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7, int var8, DoubleBuffer var9, double var10, IntBuffer var12);

    public int gelss(Layout var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, float var10, int[] var11);

    public int gelss(Layout var1, int var2, int var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7, int var8, FloatBuffer var9, float var10, IntBuffer var11);

    public int gelsd(Layout var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, double var10, int[] var12);

    public int gelsd(Layout var1, int var2, int var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7, int var8, DoubleBuffer var9, double var10, IntBuffer var12);

    public int gelsd(Layout var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, float var10, int[] var11);

    public int gelsd(Layout var1, int var2, int var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7, int var8, FloatBuffer var9, float var10, IntBuffer var11);

    public int gglse(Layout var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, double[] var10, double[] var11);

    public int gglse(Layout var1, int var2, int var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7, int var8, DoubleBuffer var9, DoubleBuffer var10, DoubleBuffer var11);

    public int gglse(Layout var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, float[] var10, float[] var11);

    public int gglse(Layout var1, int var2, int var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7, int var8, FloatBuffer var9, FloatBuffer var10, FloatBuffer var11);

    public int ggglm(Layout var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, double[] var10, double[] var11);

    public int ggglm(Layout var1, int var2, int var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7, int var8, DoubleBuffer var9, DoubleBuffer var10, DoubleBuffer var11);

    public int ggglm(Layout var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, float[] var10, float[] var11);

    public int ggglm(Layout var1, int var2, int var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7, int var8, FloatBuffer var9, FloatBuffer var10, FloatBuffer var11);

    public int geev(Layout var1, EVDJob var2, EVDJob var3, int var4, double[] var5, int var6, double[] var7, double[] var8, double[] var9, int var10, double[] var11, int var12);

    public int geev(Layout var1, EVDJob var2, EVDJob var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7, DoubleBuffer var8, DoubleBuffer var9, int var10, DoubleBuffer var11, int var12);

    public int geev(Layout var1, EVDJob var2, EVDJob var3, int var4, DoublePointer var5, int var6, DoublePointer var7, DoublePointer var8, DoublePointer var9, int var10, DoublePointer var11, int var12);

    public int geev(Layout var1, EVDJob var2, EVDJob var3, int var4, float[] var5, int var6, float[] var7, float[] var8, float[] var9, int var10, float[] var11, int var12);

    public int geev(Layout var1, EVDJob var2, EVDJob var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7, FloatBuffer var8, FloatBuffer var9, int var10, FloatBuffer var11, int var12);

    public int syev(Layout var1, EVDJob var2, UPLO var3, int var4, double[] var5, int var6, double[] var7);

    public int syev(Layout var1, EVDJob var2, UPLO var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7);

    public int syev(Layout var1, EVDJob var2, UPLO var3, int var4, float[] var5, int var6, float[] var7);

    public int syev(Layout var1, EVDJob var2, UPLO var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7);

    public int syevd(Layout var1, EVDJob var2, UPLO var3, int var4, double[] var5, int var6, double[] var7);

    public int syevd(Layout var1, EVDJob var2, UPLO var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7);

    public int syevd(Layout var1, EVDJob var2, UPLO var3, int var4, DoublePointer var5, int var6, DoublePointer var7);

    public int syevd(Layout var1, EVDJob var2, UPLO var3, int var4, float[] var5, int var6, float[] var7);

    public int syevd(Layout var1, EVDJob var2, UPLO var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7);

    public int syevr(Layout var1, EVDJob var2, EigenRange var3, UPLO var4, int var5, double[] var6, int var7, double var8, double var10, int var12, int var13, double var14, int[] var16, double[] var17, double[] var18, int var19, int[] var20);

    public int syevr(Layout var1, EVDJob var2, EigenRange var3, UPLO var4, int var5, DoubleBuffer var6, int var7, double var8, double var10, int var12, int var13, double var14, IntBuffer var16, DoubleBuffer var17, DoubleBuffer var18, int var19, IntBuffer var20);

    public int syevr(Layout var1, EVDJob var2, EigenRange var3, UPLO var4, int var5, float[] var6, int var7, float var8, float var9, int var10, int var11, float var12, int[] var13, float[] var14, float[] var15, int var16, int[] var17);

    public int syevr(Layout var1, EVDJob var2, EigenRange var3, UPLO var4, int var5, FloatBuffer var6, int var7, float var8, float var9, int var10, int var11, float var12, IntBuffer var13, FloatBuffer var14, FloatBuffer var15, int var16, IntBuffer var17);

    public int gesvd(Layout var1, SVDJob var2, SVDJob var3, int var4, int var5, double[] var6, int var7, double[] var8, double[] var9, int var10, double[] var11, int var12, double[] var13);

    public int gesvd(Layout var1, SVDJob var2, SVDJob var3, int var4, int var5, DoubleBuffer var6, int var7, DoubleBuffer var8, DoubleBuffer var9, int var10, DoubleBuffer var11, int var12, DoubleBuffer var13);

    public int gesvd(Layout var1, SVDJob var2, SVDJob var3, int var4, int var5, float[] var6, int var7, float[] var8, float[] var9, int var10, float[] var11, int var12, float[] var13);

    public int gesvd(Layout var1, SVDJob var2, SVDJob var3, int var4, int var5, FloatBuffer var6, int var7, FloatBuffer var8, FloatBuffer var9, int var10, FloatBuffer var11, int var12, FloatBuffer var13);

    public int gesdd(Layout var1, SVDJob var2, int var3, int var4, double[] var5, int var6, double[] var7, double[] var8, int var9, double[] var10, int var11);

    public int gesdd(Layout var1, SVDJob var2, int var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7, DoubleBuffer var8, int var9, DoubleBuffer var10, int var11);

    public int gesdd(Layout var1, SVDJob var2, int var3, int var4, DoublePointer var5, int var6, DoublePointer var7, DoublePointer var8, int var9, DoublePointer var10, int var11);

    public int gesdd(Layout var1, SVDJob var2, int var3, int var4, float[] var5, int var6, float[] var7, float[] var8, int var9, float[] var10, int var11);

    public int gesdd(Layout var1, SVDJob var2, int var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7, FloatBuffer var8, int var9, FloatBuffer var10, int var11);

    public int getrf(Layout var1, int var2, int var3, double[] var4, int var5, int[] var6);

    public int getrf(Layout var1, int var2, int var3, DoubleBuffer var4, int var5, IntBuffer var6);

    public int getrf(Layout var1, int var2, int var3, DoublePointer var4, int var5, IntPointer var6);

    public int getrf(Layout var1, int var2, int var3, float[] var4, int var5, int[] var6);

    public int getrf(Layout var1, int var2, int var3, FloatBuffer var4, int var5, IntBuffer var6);

    public int getrf2(Layout var1, int var2, int var3, double[] var4, int var5, int[] var6);

    public int getrf2(Layout var1, int var2, int var3, DoubleBuffer var4, int var5, IntBuffer var6);

    public int getrf2(Layout var1, int var2, int var3, float[] var4, int var5, int[] var6);

    public int getrf2(Layout var1, int var2, int var3, FloatBuffer var4, int var5, IntBuffer var6);

    public int gbtrf(Layout var1, int var2, int var3, int var4, int var5, double[] var6, int var7, int[] var8);

    public int gbtrf(Layout var1, int var2, int var3, int var4, int var5, DoubleBuffer var6, int var7, IntBuffer var8);

    public int gbtrf(Layout var1, int var2, int var3, int var4, int var5, float[] var6, int var7, int[] var8);

    public int gbtrf(Layout var1, int var2, int var3, int var4, int var5, FloatBuffer var6, int var7, IntBuffer var8);

    public int sptrf(Layout var1, UPLO var2, int var3, double[] var4, int[] var5);

    public int sptrf(Layout var1, UPLO var2, int var3, DoubleBuffer var4, IntBuffer var5);

    public int sptrf(Layout var1, UPLO var2, int var3, float[] var4, int[] var5);

    public int sptrf(Layout var1, UPLO var2, int var3, FloatBuffer var4, IntBuffer var5);

    public int getrs(Layout var1, Transpose var2, int var3, int var4, double[] var5, int var6, int[] var7, double[] var8, int var9);

    public int getrs(Layout var1, Transpose var2, int var3, int var4, DoubleBuffer var5, int var6, IntBuffer var7, DoubleBuffer var8, int var9);

    public int getrs(Layout var1, Transpose var2, int var3, int var4, DoublePointer var5, int var6, IntPointer var7, DoublePointer var8, int var9);

    public int getrs(Layout var1, Transpose var2, int var3, int var4, float[] var5, int var6, int[] var7, float[] var8, int var9);

    public int getrs(Layout var1, Transpose var2, int var3, int var4, FloatBuffer var5, int var6, IntBuffer var7, FloatBuffer var8, int var9);

    public int gbtrs(Layout var1, Transpose var2, int var3, int var4, int var5, int var6, double[] var7, int var8, int[] var9, double[] var10, int var11);

    public int gbtrs(Layout var1, Transpose var2, int var3, int var4, int var5, int var6, DoubleBuffer var7, int var8, IntBuffer var9, DoubleBuffer var10, int var11);

    public int gbtrs(Layout var1, Transpose var2, int var3, int var4, int var5, int var6, float[] var7, int var8, int[] var9, float[] var10, int var11);

    public int gbtrs(Layout var1, Transpose var2, int var3, int var4, int var5, int var6, FloatBuffer var7, int var8, IntBuffer var9, FloatBuffer var10, int var11);

    public int sptrs(Layout var1, UPLO var2, int var3, int var4, double[] var5, int[] var6, double[] var7, int var8);

    public int sptrs(Layout var1, UPLO var2, int var3, int var4, DoubleBuffer var5, IntBuffer var6, DoubleBuffer var7, int var8);

    public int sptrs(Layout var1, UPLO var2, int var3, int var4, FloatBuffer var5, IntBuffer var6, FloatBuffer var7, int var8);

    public int sptrs(Layout var1, UPLO var2, int var3, int var4, float[] var5, int[] var6, float[] var7, int var8);

    public int potrf(Layout var1, UPLO var2, int var3, double[] var4, int var5);

    public int potrf(Layout var1, UPLO var2, int var3, DoubleBuffer var4, int var5);

    public int potrf(Layout var1, UPLO var2, int var3, DoublePointer var4, int var5);

    public int potrf(Layout var1, UPLO var2, int var3, float[] var4, int var5);

    public int potrf(Layout var1, UPLO var2, int var3, FloatBuffer var4, int var5);

    public int potrf2(Layout var1, UPLO var2, int var3, double[] var4, int var5);

    public int potrf2(Layout var1, UPLO var2, int var3, DoubleBuffer var4, int var5);

    public int potrf2(Layout var1, UPLO var2, int var3, float[] var4, int var5);

    public int potrf2(Layout var1, UPLO var2, int var3, FloatBuffer var4, int var5);

    public int pbtrf(Layout var1, UPLO var2, int var3, int var4, double[] var5, int var6);

    public int pbtrf(Layout var1, UPLO var2, int var3, int var4, DoubleBuffer var5, int var6);

    public int pbtrf(Layout var1, UPLO var2, int var3, int var4, float[] var5, int var6);

    public int pbtrf(Layout var1, UPLO var2, int var3, int var4, FloatBuffer var5, int var6);

    public int pptrf(Layout var1, UPLO var2, int var3, double[] var4);

    public int pptrf(Layout var1, UPLO var2, int var3, DoubleBuffer var4);

    public int pptrf(Layout var1, UPLO var2, int var3, float[] var4);

    public int pptrf(Layout var1, UPLO var2, int var3, FloatBuffer var4);

    public int potrs(Layout var1, UPLO var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8);

    public int potrs(Layout var1, UPLO var2, int var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7, int var8);

    public int potrs(Layout var1, UPLO var2, int var3, int var4, DoublePointer var5, int var6, DoublePointer var7, int var8);

    public int potrs(Layout var1, UPLO var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8);

    public int potrs(Layout var1, UPLO var2, int var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7, int var8);

    public int pbtrs(Layout var1, UPLO var2, int var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9);

    public int pbtrs(Layout var1, UPLO var2, int var3, int var4, int var5, DoubleBuffer var6, int var7, DoubleBuffer var8, int var9);

    public int pbtrs(Layout var1, UPLO var2, int var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9);

    public int pbtrs(Layout var1, UPLO var2, int var3, int var4, int var5, FloatBuffer var6, int var7, FloatBuffer var8, int var9);

    public int pptrs(Layout var1, UPLO var2, int var3, int var4, double[] var5, double[] var6, int var7);

    public int pptrs(Layout var1, UPLO var2, int var3, int var4, DoubleBuffer var5, DoubleBuffer var6, int var7);

    public int pptrs(Layout var1, UPLO var2, int var3, int var4, float[] var5, float[] var6, int var7);

    public int pptrs(Layout var1, UPLO var2, int var3, int var4, FloatBuffer var5, FloatBuffer var6, int var7);

    public int geqrf(Layout var1, int var2, int var3, double[] var4, int var5, double[] var6);

    public int geqrf(Layout var1, int var2, int var3, DoubleBuffer var4, int var5, DoubleBuffer var6);

    public int geqrf(Layout var1, int var2, int var3, DoublePointer var4, int var5, DoublePointer var6);

    public int geqrf(Layout var1, int var2, int var3, float[] var4, int var5, float[] var6);

    public int geqrf(Layout var1, int var2, int var3, FloatBuffer var4, int var5, FloatBuffer var6);

    public int ormqr(Layout var1, Side var2, Transpose var3, int var4, int var5, int var6, double[] var7, int var8, double[] var9, double[] var10, int var11);

    public int ormqr(Layout var1, Side var2, Transpose var3, int var4, int var5, int var6, DoubleBuffer var7, int var8, DoubleBuffer var9, DoubleBuffer var10, int var11);

    public int ormqr(Layout var1, Side var2, Transpose var3, int var4, int var5, int var6, DoublePointer var7, int var8, DoublePointer var9, DoublePointer var10, int var11);

    public int ormqr(Layout var1, Side var2, Transpose var3, int var4, int var5, int var6, float[] var7, int var8, float[] var9, float[] var10, int var11);

    public int ormqr(Layout var1, Side var2, Transpose var3, int var4, int var5, int var6, FloatBuffer var7, int var8, FloatBuffer var9, FloatBuffer var10, int var11);

    public int orgqr(Layout var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7);

    public int orgqr(Layout var1, int var2, int var3, int var4, DoubleBuffer var5, int var6, DoubleBuffer var7);

    public int orgqr(Layout var1, int var2, int var3, int var4, DoublePointer var5, int var6, DoublePointer var7);

    public int orgqr(Layout var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7);

    public int orgqr(Layout var1, int var2, int var3, int var4, FloatBuffer var5, int var6, FloatBuffer var7);

    public int trtrs(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10);

    public int trtrs(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, int var6, DoubleBuffer var7, int var8, DoubleBuffer var9, int var10);

    public int trtrs(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, int var6, DoublePointer var7, int var8, DoublePointer var9, int var10);

    public int trtrs(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10);

    public int trtrs(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, int var6, FloatBuffer var7, int var8, FloatBuffer var9, int var10);
}

