/*
 * Decompiled with CFR 0.152.
 */
package smile.base.mlp;

import smile.base.mlp.ActivationFunction;
import smile.base.mlp.Layer;

public class HiddenLayer
extends Layer {
    private static final long serialVersionUID = 2L;
    private final ActivationFunction activation;

    public HiddenLayer(int n, int p, ActivationFunction activation) {
        super(n, p);
        this.activation = activation;
    }

    public String toString() {
        if (this.dropout > 0.0) {
            return String.format("%s(%d, %.2f)", this.activation.name(), this.n, this.dropout);
        }
        return String.format("%s(%d)", this.activation.name(), this.n);
    }

    @Override
    public void transform(double[] x) {
        this.activation.f(x);
    }

    @Override
    public void backpropagate(double[] lowerLayerGradient) {
        double[] output = (double[])this.output.get();
        double[] outputGradient = (double[])this.outputGradient.get();
        this.activation.g(outputGradient, output);
        if (lowerLayerGradient != null) {
            this.weight.tv(outputGradient, lowerLayerGradient);
        }
    }
}

