/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;

public class RealPenaltyEditDistance
implements GenericDistanceMeasure<double[]> {
    private static final long serialVersionUID = 7419503714378886631L;
    private final double gap;
    private final double radiusPercentage;

    public RealPenaltyEditDistance() {
        this(0.0, 1.0);
    }

    public RealPenaltyEditDistance(double gap, double radiusPercentage) {
        this.gap = gap;
        this.radiusPercentage = radiusPercentage;
    }

    @Override
    public double compute(double[] a, double[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(double[] a, double[] b, double cutOffValue) {
        int i;
        int n = b.length;
        int radius = (int)((double)n * this.radiusPercentage);
        int n1 = n + 1;
        double[] prev = new double[n1];
        double[] current = new double[n1];
        double[] db = new double[n];
        current[0] = 0.0;
        prev[0] = 0.0;
        for (i = 1; i < n1; ++i) {
            db[i - 1] = this.distance(b[i - 1], this.gap);
            prev[i] = prev[i - 1] + db[i - 1];
        }
        for (i = 0; i < a.length; ++i) {
            int start = FastMath.max(0, i - radius);
            int end = FastMath.min(n - 1, i + radius);
            double da = this.distance(a[i], this.gap);
            current[0] = current[0] + da;
            double min = Double.POSITIVE_INFINITY;
            for (int j = start; j <= end; ++j) {
                double x = prev[j + 1] + da;
                double y = current[j] + db[j];
                double z = prev[j] + this.distance(a[i], b[j]);
                current[j + 1] = FastMath.min(x, FastMath.min(y, z));
                if (!(current[j + 1] < min)) continue;
                min = current[j + 1];
            }
            if (min > cutOffValue) {
                return Double.POSITIVE_INFINITY;
            }
            System.arraycopy(current, 0, prev, 0, n1);
        }
        if (current[n] > cutOffValue) {
            return Double.POSITIVE_INFINITY;
        }
        return current[n];
    }

    protected double distance(double a, double b) {
        return FastMath.abs(a - b);
    }
}

