/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.timelines.blocks;

import io.intino.sumus.chronos.TimelineStore;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Iterator;
import java.util.stream.IntStream;

public class Data
implements TimelineStore.Data {
    public static final int HEADER_SIZE = 6;
    public static final int MEASUREMENT_BYTE_SIZE = 8;
    private final long position;
    private final int recordByteSize;
    private final Instant[] instants;
    private final ByteBuffer buffer;

    public Data(long position, Instant[] instants, int numMeasurementsPerRecord, ByteBuffer buffer) {
        this.position = position;
        this.instants = instants;
        this.recordByteSize = numMeasurementsPerRecord * 8;
        this.buffer = buffer;
    }

    public long position() {
        return this.position;
    }

    @Override
    public int numRecords() {
        return this.buffer.remaining() / this.recordByteSize;
    }

    @Override
    public int numMeasurementsPerRecord() {
        return this.recordByteSize / 8;
    }

    @Override
    public int recordByteSize() {
        return this.recordByteSize;
    }

    @Override
    public ByteBuffer dataBuffer() {
        return this.buffer;
    }

    @Override
    public TimelineStore.Data.Record record(int index) {
        return new Record(index);
    }

    @Override
    public Iterator<TimelineStore.Data.Record> iterator() {
        return IntStream.range(0, this.numRecords()).mapToObj(x$0 -> new Record(x$0)).iterator();
    }

    public static int calculateRecordByteSize(int numMeasurements) {
        return numMeasurements * 8;
    }

    public class Record
    implements TimelineStore.Data.Record {
        private final int index;
        private final int offset;

        private Record(int index) {
            this.index = index;
            this.offset = index * Data.this.recordByteSize;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public Instant instant() {
            return Data.this.instants[this.index];
        }

        @Override
        public double[] values() {
            double[] values = new double[this.numMeasurements()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.get(i);
            }
            return values;
        }

        @Override
        public double get(int i) {
            if (i < 0 || i >= this.numMeasurements()) {
                throw new IndexOutOfBoundsException("Index must be >= 0 && < " + this.numMeasurements());
            }
            return Data.this.buffer.getDouble(this.offset + i * 8);
        }

        @Override
        public int byteSize() {
            return Data.this.recordByteSize();
        }

        @Override
        public int numMeasurements() {
            return Data.this.numMeasurementsPerRecord();
        }
    }
}

