/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Program;
import io.intino.sumus.chronos.TimeSeries;
import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.processors.Interpolator;
import io.intino.sumus.chronos.processors.Resampler;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class TimelineImpl
implements Timeline {
    private final Instant[] instants;
    private final Map<Magnitude, double[]> measurements;

    public TimelineImpl(Instant[] instants, Map<Magnitude, double[]> measurements) {
        this.instants = instants;
        this.measurements = measurements instanceof LinkedHashMap ? measurements : new LinkedHashMap(measurements);
    }

    @Override
    public int magnitudesCount() {
        return this.measurements.size();
    }

    @Override
    public int instantsCount() {
        return this.instants.length;
    }

    @Override
    public Set<Magnitude> magnitudes() {
        return this.measurements.keySet();
    }

    @Override
    public Instant[] instants() {
        return this.instants;
    }

    @Override
    public Map<Magnitude, double[]> measurements() {
        return this.measurements;
    }

    @Override
    public Instant instant(int index) {
        return this.instants[index];
    }

    @Override
    public boolean has(String magnitude) {
        return this.has(new Magnitude(magnitude));
    }

    @Override
    public boolean has(Magnitude magnitude) {
        return this.measurements.containsKey(magnitude);
    }

    @Override
    public TimeSeries get(String magnitude) {
        return this.has(magnitude) ? this.get(this.find(magnitude)) : this.emptyTimeSeries();
    }

    @Override
    public TimeSeries get(Magnitude magnitude) {
        return new TimeSeries(magnitude.model, this.instants, this.measurements.getOrDefault(magnitude, Magnitude.NaN(this.instants.length)));
    }

    private TimeSeries emptyTimeSeries() {
        return new TimeSeries(Magnitude.Model.Default, this.instants, Magnitude.NaN(this.instants.length));
    }

    @Override
    public boolean isBefore(Timeline timeline) {
        if (timeline.instantsCount() == 0) {
            return false;
        }
        return this.isEndOfTimes(timeline.instant(0));
    }

    @Override
    public boolean isAfter(Timeline timeline) {
        if (timeline.instantsCount() == 0) {
            return false;
        }
        return this.isBeginningOfTimes(timeline.instant(0));
    }

    @Override
    public Timeline.Point first() {
        return this.point(0);
    }

    @Override
    public Timeline.Point last() {
        return this.point(this.lastIndex());
    }

    @Override
    public Timeline.Point at(Instant instant) {
        return this.point(this.indexOf(instant));
    }

    @Override
    public Timeline head(int length) {
        return this.sub(0, this.limitHigh(length));
    }

    @Override
    public Timeline tail(int length) {
        return this.sub(this.limitLow(this.instantsCount() - length), this.instantsCount());
    }

    @Override
    public Timeline from(Instant instant) {
        if (this.isEndOfTimes(instant)) {
            return Timeline.empty();
        }
        return this.sub(this.indexOf(instant), this.instantsCount());
    }

    @Override
    public Timeline from(Instant instant, int length) {
        if (this.isEndOfTimes(instant)) {
            return Timeline.empty();
        }
        int from = this.indexOf(instant);
        return length > 0 ? this.sub(from, this.limitHigh(from + length)) : this.sub(this.limitLow(from + 1 + length), this.limitHigh(from + 1));
    }

    @Override
    public Timeline from(Instant instant, Instant to) {
        if (this.isEndOfTimes(instant)) {
            return Timeline.empty();
        }
        if (this.isEndOfTimes(to)) {
            return this.from(instant);
        }
        return this.sub(this.indexOf(instant), this.indexOf(to));
    }

    @Override
    public Timeline to(Instant instant) {
        if (this.isEndOfTimes(instant)) {
            return this;
        }
        return this.sub(0, this.indexOf(instant));
    }

    private Timeline.Point point(int index) {
        return this.isInRange(index) ? new PointImpl(index) : null;
    }

    private boolean isBeginningOfTimes(Instant instant) {
        return this.firstInstant().isAfter(instant);
    }

    private boolean isEndOfTimes(Instant instant) {
        return this.lastInstant().isBefore(instant);
    }

    private int limitLow(int offset) {
        return Math.max(0, offset);
    }

    private int limitHigh(int offset) {
        return Math.min(offset, this.instantsCount());
    }

    private Instant firstInstant() {
        return this.instants[0];
    }

    private Instant lastInstant() {
        return this.instants[this.lastIndex()];
    }

    private Timeline sub(int from, int to) {
        return new TimelineImpl(this.instants(from, to), this.values(from, to));
    }

    private Magnitude find(String label) {
        return this.measurements.keySet().stream().filter(m -> m.label.equalsIgnoreCase(label)).findFirst().orElse(null);
    }

    @Override
    public Stream<Timeline.Point> stream() {
        return IntStream.iterate(0, i -> i < this.instantsCount(), i -> i + 1).mapToObj(this::point);
    }

    @Override
    public Iterator<Timeline.Point> iterator() {
        return new Iterator<Timeline.Point>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < TimelineImpl.this.instantsCount();
            }

            @Override
            public Timeline.Point next() {
                return new PointImpl(this.i++);
            }
        };
    }

    @Override
    public Timeline add(Timeline timeline) {
        assert (Arrays.equals(this.instants(), timeline.instants()));
        TimelineImpl result = new TimelineImpl(this.instants, new LinkedHashMap<Magnitude, double[]>(this.measurements));
        for (Magnitude magnitude : timeline.magnitudes()) {
            TimeSeries series = result.has(magnitude) ? timeline.get(magnitude).plus(this.get(magnitude)) : timeline.get(magnitude);
            result.put(magnitude, series);
        }
        return result;
    }

    @Override
    public Timeline add(String magnitude, TimeSeries timeSeries) {
        return this.add(new Magnitude(magnitude), timeSeries);
    }

    @Override
    public Timeline add(Magnitude magnitude, TimeSeries timeSeries) {
        assert (Arrays.equals(timeSeries.instants, this.instants));
        TimelineImpl result = new TimelineImpl(this.instants, new LinkedHashMap<Magnitude, double[]>(this.measurements));
        result.put(magnitude, timeSeries);
        return result;
    }

    @Override
    public Timeline add(String magnitude, Function<Timeline, TimeSeries> function) {
        return this.add(new Magnitude(magnitude), function);
    }

    @Override
    public Timeline add(Magnitude magnitude, Function<Timeline, TimeSeries> function) {
        TimelineImpl result = new TimelineImpl(this.instants, new LinkedHashMap<Magnitude, double[]>(this.measurements));
        result.put(magnitude, function.apply(this));
        return result;
    }

    @Override
    public Timeline concat(Timeline timeline) {
        assert (this.isBefore(timeline));
        TimelineImpl result = new TimelineImpl(TimeSeries.concat(this.instants(), timeline.instants()), new LinkedHashMap<Magnitude, double[]>());
        Set<Magnitude> magnitudes = TimelineImpl.concat(this.magnitudes(), timeline.magnitudes());
        for (Magnitude magnitude : magnitudes) {
            result.put(magnitude, TimeSeries.concat(this.get((Magnitude)magnitude).values, timeline.get((Magnitude)magnitude).values));
        }
        return result;
    }

    @Override
    public Timeline compose(Function<Magnitude, Magnitude> function) {
        TimelineImpl result = new TimelineImpl(this.instants, new LinkedHashMap<Magnitude, double[]>());
        for (Magnitude magnitude : this.magnitudes()) {
            Magnitude m = function.apply(magnitude);
            TimeSeries series = result.has(m) ? result.get(m).plus(this.get(magnitude)) : this.get(magnitude);
            result.put(m, series);
        }
        return result;
    }

    private void put(Magnitude magnitude, TimeSeries series) {
        this.measurements.put(magnitude, series.values);
    }

    private void put(Magnitude magnitude, double[] values) {
        this.put(magnitude, new TimeSeries(Magnitude.Model.Default, this.instants, values));
    }

    @Override
    public Timeline resampleBy(Period period) {
        return this.instantsCount() > 0 ? this.resampleBy(period, this.sizeWith(period)) : this;
    }

    @Override
    public Timeline resampleBy(Period period, int size) {
        return new Resampler(this).execute(period, size);
    }

    @Override
    public Timeline execute(Program program) {
        return program.run(this);
    }

    @Override
    public Timeline interpolate() {
        return new Interpolator(this).execute();
    }

    private static Set<Magnitude> concat(Set<Magnitude> a, Set<Magnitude> b) {
        HashSet<Magnitude> magnitudes = new HashSet<Magnitude>();
        magnitudes.addAll(a);
        magnitudes.addAll(b);
        return magnitudes;
    }

    private int sizeWith(Period period) {
        return period.length(this.first().instant(), this.last().instant().plusSeconds(1L));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this == o || this.equals((TimelineImpl)o);
    }

    private boolean equals(TimelineImpl timeline) {
        return this.instantsAreEqual(timeline) && this.measurements.size() == timeline.magnitudesCount() && this.valuesAreEqual(timeline);
    }

    public boolean instantsAreEqual(TimelineImpl timeline) {
        return Arrays.equals(this.instants, timeline.instants);
    }

    public boolean valuesAreEqual(TimelineImpl timeline) {
        return this.measurements.keySet().stream().map(m -> Arrays.equals(this.measurements.get(m), timeline.measurements.get(m))).reduce(true, (a, b) -> a != false && b != false);
    }

    public int hashCode() {
        int result = Objects.hash(this.measurements);
        result = 31 * result + Arrays.hashCode(this.instants);
        return result;
    }

    private int indexOf(Instant instant) {
        int index = Arrays.binarySearch(this.instants, instant);
        return index >= 0 ? index : Math.min(Math.abs(-index - 1), this.lastIndex());
    }

    private int lastIndex() {
        return this.instantsCount() - 1;
    }

    private boolean isInRange(int index) {
        return index >= 0 && index < this.instantsCount();
    }

    private Instant[] instants(int from, int to) {
        return Arrays.copyOfRange(this.instants, from, to);
    }

    private Map<Magnitude, double[]> values(int from, int to) {
        return this.magnitudes().stream().collect(Collectors.toMap(m -> m, m -> Arrays.copyOfRange(this.valuesOf((Magnitude)m), from, to)));
    }

    private double[] valuesOf(Magnitude magnitude) {
        return this.measurements.get(magnitude);
    }

    public Map<String, double[]> collect(String ... magnitudes) {
        return Arrays.stream(magnitudes).collect(Collectors.toMap(m -> m, m -> this.get((String)m).values, (a, b) -> b));
    }

    public String toString() {
        return this.first() + ".. " + this.last();
    }

    public static class Builder
    implements Timeline.Builder {
        private final Instant[] instants;
        private final Map<Magnitude, double[]> magnitudes;
        private int position;

        public Builder(int size) {
            this(new Instant[size]);
        }

        public Builder(Instant[] instants) {
            this.instants = instants;
            this.magnitudes = new LinkedHashMap<Magnitude, double[]>();
            this.position = -1;
        }

        @Override
        public Magnitude get(String magnitude) {
            return this.magnitudes().stream().filter(m -> m.label.equals(magnitude)).findFirst().orElse(null);
        }

        private Set<Magnitude> magnitudes() {
            return this.magnitudes.keySet();
        }

        @Override
        public Timeline.Builder put(Timeline timeline) {
            this.magnitudes.putAll(timeline.measurements());
            return this;
        }

        @Override
        public Timeline.Builder put(Magnitude magnitude, TimeSeries series) {
            assert (this.instants.length == series.length());
            this.magnitudes.put(magnitude, series.values);
            return this;
        }

        @Override
        public Timeline.Builder put(Magnitude magnitude, double[] values) {
            assert (this.instants.length == values.length);
            this.magnitudes.put(magnitude, values);
            return this;
        }

        @Override
        public Timeline.Builder put(Map<Magnitude, double[]> values) {
            values.keySet().forEach(m -> this.put((Magnitude)m, new TimeSeries(Magnitude.Model.Default, this.instants, (double[])values.get(m))));
            return this;
        }

        @Override
        public Timeline.Builder set(Instant instant) {
            this.instants[++this.position] = instant;
            return this;
        }

        @Override
        public boolean isComplete() {
            return this.position + 1 >= this.instants.length;
        }

        @Override
        public void set(TimelineStore.SensorModel sensorModel, TimelineStore.Data dataBlock) {
            Magnitude[] magnitudes = sensorModel.magnitudes();
            for (Magnitude magnitude : magnitudes) {
                this.register(magnitude);
            }
            this.position = Math.max(this.position, 0);
            for (TimelineStore.Data.Record record : dataBlock) {
                int position = this.position + record.index();
                this.instants[position] = record.instant();
                for (int i = 0; i < record.numMeasurements(); ++i) {
                    this.setMeasurement(position, magnitudes[i], record.get(i));
                }
            }
            this.position += dataBlock.numRecords();
        }

        @Override
        public void set(Magnitude[] magnitudes, Instant instant, double[] values) {
            this.set(instant);
            for (int i = 0; i < values.length; ++i) {
                this.setMeasurement(this.position, magnitudes[i], values[i]);
            }
        }

        @Override
        public Timeline.Builder set(String magnitude, double value) {
            this.set(new Magnitude(magnitude), value);
            return this;
        }

        @Override
        public Timeline.Builder set(Magnitude magnitude, double value) {
            if (magnitude == null) {
                return this;
            }
            this.register(magnitude);
            this.setMeasurement(this.position, magnitude, value);
            return this;
        }

        private void setMeasurement(int position, Magnitude magnitude, double value) {
            if (!Double.isNaN(value)) {
                this.magnitudes.get((Object)magnitude)[position] = value;
            }
        }

        @Override
        public void register(Magnitude magnitude) {
            if (this.magnitudes.containsKey(magnitude)) {
                return;
            }
            this.magnitudes.put(magnitude, Magnitude.NaN(this.instants.length));
        }

        @Override
        public Timeline build() {
            return new TimelineImpl(this.instants, this.magnitudes);
        }

        @Override
        public TimeSeries series(Magnitude magnitude) {
            return new TimeSeries(Magnitude.Model.Default, this.instants, this.magnitudes.get(magnitude));
        }
    }

    public class PointImpl
    implements Timeline.Point {
        final int index;

        public PointImpl(int index) {
            this.index = index;
        }

        @Override
        public Instant instant() {
            return TimelineImpl.this.instants[this.index];
        }

        @Override
        public Set<Magnitude> magnitudes() {
            return TimelineImpl.this.magnitudes();
        }

        @Override
        public boolean has(String magnitude) {
            return this.has(new Magnitude(magnitude));
        }

        @Override
        public boolean has(Magnitude magnitude) {
            return TimelineImpl.this.has(magnitude);
        }

        @Override
        public double value(String magnitude) {
            return this.value(new Magnitude(magnitude));
        }

        @Override
        public double value(Magnitude magnitude) {
            return this.has(magnitude) ? TimelineImpl.this.valuesOf(magnitude)[this.index] : Double.NaN;
        }

        @Override
        public double[] values() {
            return this.magnitudes().stream().mapToDouble(this::value).toArray();
        }

        public String toString() {
            return this.instant() + this.magnitudes().stream().map(m -> "\t" + this.format(this.value((Magnitude)m))).collect(Collectors.joining());
        }

        @Override
        public Stream<Timeline.Point> forward() {
            return IntStream.range(this.index, TimelineImpl.this.instantsCount()).mapToObj(x$0 -> TimelineImpl.this.point(x$0));
        }

        @Override
        public Stream<Timeline.Point> backward() {
            return IntStream.iterate(this.index, i -> i >= 0, i -> i - 1).mapToObj(x$0 -> TimelineImpl.this.point(x$0));
        }

        private String format(double value) {
            long v = (long)value;
            return value == (double)v ? String.valueOf(v) : String.valueOf(value);
        }

        @Override
        public Timeline.Point next() {
            return this.step(1);
        }

        @Override
        public Timeline.Point prev() {
            return this.step(-1);
        }

        @Override
        public Timeline.Point step(int value) {
            return TimelineImpl.this.point(this.index + value);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this == o || this.index == ((PointImpl)o).index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }
    }
}

