/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework;

import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.MagritteException;
import io.intino.magritte.framework.Model;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.NodeCloner;
import io.intino.magritte.io.model.Stash;
import io.intino.magritte.io.model.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

class StashReader {
    private static List<String> proteoTypes = new ArrayList<String>(Arrays.asList("Concept", "MetaConcept", "Aspect", "Facet", "MetaAspect"));
    private final Graph graph;

    StashReader(Graph graph) {
        this.graph = graph;
    }

    void read(Stash stash) {
        this.loadConcepts(stash.concepts);
        this.loadNodes(this.graph.model, stash.nodes);
    }

    private void loadConcepts(List<io.intino.magritte.io.model.Concept> rawConcepts) {
        for (io.intino.magritte.io.model.Concept rawConcept : rawConcepts) {
            this.graph.layerFactory.register(rawConcept.name, rawConcept.className);
            this.loadConcept(this.graph.concept$(rawConcept.name), rawConcept);
        }
    }

    private void loadConcept(Concept concept, io.intino.magritte.io.model.Concept rawConcept) {
        concept.parent(this.graph.concept$(rawConcept.parent));
        List<Concept> concepts = this.typesWithoutConcept(rawConcept);
        concept.metatype = !concepts.isEmpty() ? concepts.get(0) : null;
        concept.concepts(this.metaTypesOf(concepts));
        concept.isAbstract = rawConcept.isAbstract;
        concept.isMetaConcept = rawConcept.isMetaConcept;
        concept.isAspect = rawConcept.isAspect;
        concept.isMain = rawConcept.isMain;
        concept.layerClass = this.graph.layerFactory.layerClass(concept.id);
        concept.contentRules = rawConcept.contentRules.stream().map(c -> new Concept.Content(this.graph.concept$(c.type), c.min, c.max)).collect(Collectors.toSet());
        concept.nodes = this.loadVirtualNodes(rawConcept.nodes);
        concept.parameters = rawConcept.parameters.stream().collect(Collectors.toMap(v -> v.name, v -> v.values, (oldK, newK) -> newK, LinkedHashMap::new));
        concept.variables = rawConcept.variables.stream().collect(Collectors.toMap(v -> v.name, v -> v.values, (oldK, newK) -> newK, LinkedHashMap::new));
    }

    private List<Concept> typesWithoutConcept(io.intino.magritte.io.model.Concept taraConcept) {
        ArrayList<Concept> result = new ArrayList<Concept>();
        for (String type : taraConcept.types) {
            if (proteoTypes.contains(type)) continue;
            result.add(this.graph.concept$(type));
        }
        return result;
    }

    private List<Node> loadNodes(Node parent, List<io.intino.magritte.io.model.Node> rawNodes) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (io.intino.magritte.io.model.Node rawNode : rawNodes) {
            Node node = this.graph.node$(rawNode.name);
            node.owner(parent);
            this.loadNode(node, rawNode);
            parent.add(node);
            result.add(node);
        }
        return result;
    }

    private Node loadNode(Node node, io.intino.magritte.io.model.Node rawNode) {
        List<Concept> metaTypes = this.metaTypesOf(this.conceptsOf(rawNode.layers));
        this.addConcepts(node, metaTypes);
        this.loadNodes(node, rawNode.nodes);
        this.cloneNodes(node);
        this.saveVariables(node, rawNode.variables, metaTypes);
        return node;
    }

    private List<Node> loadVirtualNodes(List<io.intino.magritte.io.model.Node> nodes) {
        Model root = new Model(this.graph, Collections.emptyMap());
        return this.loadNodes(root, nodes);
    }

    private void addConcepts(Node node, List<Concept> metaTypes) {
        node.addLayers(metaTypes);
        node.syncLayers();
    }

    private List<Concept> conceptsOf(List<String> layers) {
        ArrayList<Concept> result = new ArrayList<Concept>();
        for (String layer : layers) {
            Concept concept = this.graph.concepts.get(layer);
            if (concept == null) {
                throw new MagritteException("Concept " + layer + " not found");
            }
            result.add(concept);
        }
        return result;
    }

    private void saveVariables(Node node, List<Variable> variables, List<Concept> types) {
        LinkedHashMap variableMap = new LinkedHashMap();
        types.forEach(c -> variableMap.putAll(c.variables));
        types.forEach(t2 -> variableMap.putAll(t2.parameters));
        variables.forEach(e -> variableMap.put(e.name, e.values));
        this.graph.addVariableIn(node, variableMap);
    }

    private void cloneNodes(Node node) {
        NodeCloner.clone(this.nodesOf(node), node, this.graph);
    }

    private List<Node> nodesOf(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (String typeName : node.typeNames) {
            nodes.addAll(this.graph.concepts.get((Object)typeName).nodes);
        }
        return nodes;
    }

    private List<Concept> metaTypesOf(Collection<Concept> metaConcepts) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        for (Concept metaConcept : metaConcepts) {
            concepts.addAll(this.metaTypesOf(metaConcept.concepts));
            concepts.add(metaConcept);
        }
        return concepts;
    }
}

