/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.cosmos.datahub.messages.universe.SoftwareAssertion;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;

public class ServiceAssertion
extends SoftwareAssertion
implements Serializable {
    public ServiceAssertion(String ss, String id) {
        this(new MessageEvent("ServiceAssertion", ss).toMessage(), id);
    }

    public ServiceAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public ServiceAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private ServiceAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public ServiceAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public ServiceAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    @Override
    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    @Override
    public ServiceAssertion enabled(boolean enabled) {
        this.message.set("enabled", enabled);
        return this;
    }

    public static ServiceAssertion fromString(String event) {
        return new ServiceAssertion(new MessageReader(event).next());
    }

    public String url() {
        return !this.message.contains("url") ? null : this.message.get("url").asString();
    }

    public ServiceAssertion url(String url) {
        if (url == null) {
            this.message.remove("url");
        } else {
            this.message.set("url", url);
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }
}

