/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import com.google.gson.JsonElement;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.framework.Activity;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.Message;
import java.util.Map;
import java.util.stream.Collectors;

public class UpdateActivityConfigurationRequest
extends ContainerRequest {
    public static final String ID = "updateActivityConfiguration";
    private final ContainerBox box;

    public UpdateActivityConfigurationRequest(ContainerBox box, Activity.Context context, ContainerStore store) {
        this.box = box;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        try {
            String activityId = this.activity(request);
            if (activityId == null) {
                return new RequestAttendant.RequestResult(false, "Activity not found");
            }
            Map<String, String> params = this.activityParameters(request).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsString()));
            Activity.Result result = this.box.activities().updateConfiguration(activityId, params);
            return new RequestAttendant.RequestResult(result.success(), result.remarks());
        }
        catch (Throwable e2) {
            Logger.error(e2);
            return new RequestAttendant.RequestResult(false, e2.getMessage());
        }
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }
}

