/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventReader;
import io.intino.alexandria.iteratorstream.ResourceIteratorStream;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class EventStream<T extends Event>
extends ResourceIteratorStream<T> {
    public static <T extends Event> Stream<T> sequence(List<Supplier<Stream<T>>> streams) {
        return new EventStream<T>(new SequenceIterator<T>(streams));
    }

    public static <T extends Event> Stream<T> merge(Stream<Stream<T>> streams) {
        return new EventStream<T>(new MergeIterator<T>(streams));
    }

    public static <T extends Event> Stream<T> of(File file) throws IOException {
        return new EventStream(EventReader.of(file));
    }

    public EventStream(Iterator<T> iterator) {
        super(iterator);
    }

    private static Exception tryClose(Iterator<?> iterator) {
        if (iterator instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)iterator)).close();
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    private static class SequenceIterator<T>
    implements Iterator<T> {
        private final Iterator<Supplier<Stream<T>>> sources;
        private Iterator<T> currentIterator;

        public SequenceIterator(List<Supplier<Stream<T>>> streams) {
            this.sources = streams.iterator();
            this.advanceToNextIterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public T next() {
            T next = this.currentIterator.next();
            this.advanceToNextIteratorIfNecessary();
            return next;
        }

        private void advanceToNextIteratorIfNecessary() {
            if (!this.currentIterator.hasNext()) {
                this.advanceToNextIterator();
            }
        }

        private void advanceToNextIterator() {
            if (this.currentIterator != null) {
                EventStream.tryClose(this.currentIterator);
            }
            this.currentIterator = null;
            this.currentIterator = this.sources.hasNext() ? this.sources.next().get().iterator() : null;
        }
    }

    private static class MergeIterator<T extends Event>
    implements Iterator<T>,
    AutoCloseable {
        private final Iterator<T>[] inputs;
        private final Event[] current;

        public MergeIterator(Stream<Stream<T>> streams) {
            this.inputs = (Iterator[])streams.map(BaseStream::iterator).toArray(Iterator[]::new);
            this.current = (Event[])Arrays.stream(this.inputs).map(this::next).toArray(Event[]::new);
        }

        @Override
        public boolean hasNext() {
            return !Arrays.stream(this.current).allMatch(Objects::isNull);
        }

        @Override
        public T next() {
            return this.next(this.minIndex());
        }

        private T next(int index) {
            Event message = this.current[index];
            this.current[index] = this.next(this.inputs[index]);
            return (T)message;
        }

        private T next(Iterator<T> input) {
            if (input.hasNext()) {
                return (T)((Event)input.next());
            }
            EventStream.tryClose(input);
            return null;
        }

        private int minIndex() {
            return IntStream.range(0, this.current.length).boxed().min(this::comparingTimestamp).orElse(-1);
        }

        private int comparingTimestamp(int a, int b) {
            return this.tsOf(this.current[a]).compareTo(this.tsOf(this.current[b]));
        }

        private Instant tsOf(Event event) {
            return event != null ? event.ts() : Instant.MAX;
        }

        @Override
        public void close() throws Exception {
            Exception e = null;
            for (Iterator<T> iterator : this.inputs) {
                e = EventStream.tryClose(iterator);
            }
            if (e != null) {
                throw e;
            }
        }
    }
}

