/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import smile.sort.Sort;

public interface QuickSelect {
    public static int select(int[] x, int k) {
        int n = x.length;
        int l = 0;
        int ir = n - 1;
        while (true) {
            if (ir <= l + 1) {
                if (ir == l + 1 && x[ir] < x[l]) {
                    Sort.swap(x, l, ir);
                }
                return x[k];
            }
            int mid = l + ir >> 1;
            Sort.swap(x, mid, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
            }
            int i = l + 1;
            int j = ir;
            int a = x[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    public static float select(float[] x, int k) {
        int n = x.length;
        int l = 0;
        int ir = n - 1;
        while (true) {
            if (ir <= l + 1) {
                if (ir == l + 1 && x[ir] < x[l]) {
                    Sort.swap(x, l, ir);
                }
                return x[k];
            }
            int mid = l + ir >> 1;
            Sort.swap(x, mid, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
            }
            int i = l + 1;
            int j = ir;
            float a = x[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    public static double select(double[] x, int k) {
        int n = x.length;
        int l = 0;
        int ir = n - 1;
        while (true) {
            if (ir <= l + 1) {
                if (ir == l + 1 && x[ir] < x[l]) {
                    Sort.swap(x, l, ir);
                }
                return x[k];
            }
            int mid = l + ir >> 1;
            Sort.swap(x, mid, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
            }
            int i = l + 1;
            int j = ir;
            double a = x[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    public static <T extends Comparable<? super T>> T select(T[] x, int k) {
        int n = x.length;
        int l = 0;
        int ir = n - 1;
        while (true) {
            if (ir <= l + 1) {
                if (ir == l + 1 && x[ir].compareTo(x[l]) < 0) {
                    Sort.swap(x, l, ir);
                }
                return x[k];
            }
            int mid = l + ir >> 1;
            Sort.swap(x, mid, l + 1);
            if (x[l].compareTo(x[ir]) > 0) {
                Sort.swap(x, l, ir);
            }
            if (x[l + 1].compareTo(x[ir]) > 0) {
                Sort.swap(x, l + 1, ir);
            }
            if (x[l].compareTo(x[l + 1]) > 0) {
                Sort.swap(x, l, l + 1);
            }
            int i = l + 1;
            int j = ir;
            T a = x[l + 1];
            while (true) {
                if (x[++i].compareTo(a) < 0) {
                    continue;
                }
                while (x[--j].compareTo(a) > 0) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    public static int median(int[] x) {
        int k = x.length / 2;
        return QuickSelect.select(x, k);
    }

    public static float median(float[] x) {
        int k = x.length / 2;
        return QuickSelect.select(x, k);
    }

    public static double median(double[] x) {
        int k = x.length / 2;
        return QuickSelect.select(x, k);
    }

    public static <T extends Comparable<? super T>> T median(T[] x) {
        int k = x.length / 2;
        return (T)QuickSelect.select(x, (int)k);
    }

    public static int q1(int[] x) {
        int k = x.length / 4;
        return QuickSelect.select(x, k);
    }

    public static float q1(float[] x) {
        int k = x.length / 4;
        return QuickSelect.select(x, k);
    }

    public static double q1(double[] x) {
        int k = x.length / 4;
        return QuickSelect.select(x, k);
    }

    public static <T extends Comparable<? super T>> T q1(T[] x) {
        int k = x.length / 4;
        return (T)QuickSelect.select(x, (int)k);
    }

    public static int q3(int[] x) {
        int k = 3 * x.length / 4;
        return QuickSelect.select(x, k);
    }

    public static float q3(float[] x) {
        int k = 3 * x.length / 4;
        return QuickSelect.select(x, k);
    }

    public static double q3(double[] x) {
        int k = 3 * x.length / 4;
        return QuickSelect.select(x, k);
    }

    public static <T extends Comparable<? super T>> T q3(T[] x) {
        int k = 3 * x.length / 4;
        return (T)QuickSelect.select(x, (int)k);
    }
}

