/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import smile.clustering.linkage.Linkage;

class FastPair {
    private final int[] points;
    private final int[] index;
    private int npoints;
    private final int[] neighbor;
    private final float[] distance;
    private final Linkage linkage;

    public FastPair(int[] points, Linkage linkage) {
        int i;
        this.points = points;
        this.linkage = linkage;
        this.npoints = points.length;
        this.neighbor = new int[this.npoints];
        this.index = new int[this.npoints];
        this.distance = new float[this.npoints];
        for (i = 0; i < this.npoints - 1; ++i) {
            int nbr = i + 1;
            float nbd = Float.MAX_VALUE;
            for (int j = i + 1; j < this.npoints; ++j) {
                float d = linkage.d(points[i], points[j]);
                if (!(d < nbd)) continue;
                nbr = j;
                nbd = d;
            }
            this.distance[points[i]] = nbd;
            this.neighbor[points[i]] = points[nbr];
            points[nbr] = points[i + 1];
            points[i + 1] = this.neighbor[points[i]];
        }
        this.neighbor[points[this.npoints - 1]] = points[this.npoints - 1];
        this.distance[points[this.npoints - 1]] = Float.MAX_VALUE;
        for (i = 0; i < this.npoints; ++i) {
            this.index[points[i]] = i;
        }
    }

    private void findNeighbor(int p) {
        if (this.npoints == 1) {
            this.neighbor[p] = p;
            this.distance[p] = Float.MAX_VALUE;
            return;
        }
        int first = 0;
        if (p == this.points[first]) {
            first = 1;
        }
        this.neighbor[p] = this.points[first];
        this.distance[p] = this.linkage.d(p, this.neighbor[p]);
        for (int i = first + 1; i < this.npoints; ++i) {
            float d;
            int q = this.points[i];
            if (q == p || !((d = this.linkage.d(p, q)) < this.distance[p])) continue;
            this.distance[p] = d;
            this.neighbor[p] = q;
        }
    }

    public void add(int p) {
        this.findNeighbor(p);
        ++this.npoints;
        this.points[this.index[p]] = p;
    }

    public void remove(int p) {
        --this.npoints;
        int q = this.index[p];
        this.points[q] = this.points[this.npoints];
        this.index[this.points[q]] = q;
        for (int i = 0; i < this.npoints; ++i) {
            if (this.neighbor[this.points[i]] != p) continue;
            this.findNeighbor(this.points[i]);
        }
    }

    public double getNearestPair(int[] pair) {
        if (this.npoints < 2) {
            throw new IllegalStateException("FastPair: not enough points to form pair");
        }
        double d = this.distance[this.points[0]];
        int r = 0;
        for (int i = 1; i < this.npoints; ++i) {
            if (!((double)this.distance[this.points[i]] < d)) continue;
            d = this.distance[this.points[i]];
            r = i;
        }
        pair[0] = this.points[r];
        pair[1] = this.neighbor[pair[0]];
        if (pair[0] > pair[1]) {
            int t2 = pair[0];
            pair[0] = pair[1];
            pair[1] = t2;
        }
        return d;
    }

    public void updatePoint(int p) {
        this.neighbor[p] = p;
        this.distance[p] = Float.MAX_VALUE;
        for (int i = 0; i < this.npoints; ++i) {
            int q = this.points[i];
            if (q == p) continue;
            float d = this.linkage.d(p, q);
            if (d < this.distance[p]) {
                this.distance[p] = d;
                this.neighbor[p] = q;
            }
            if (this.neighbor[q] != p) continue;
            if (d > this.distance[q]) {
                this.findNeighbor(q);
                continue;
            }
            this.distance[q] = d;
        }
    }

    public void updateDistance(int p, int q) {
        float d = this.linkage.d(p, q);
        if (d < this.distance[p]) {
            this.distance[p] = d;
            this.neighbor[p] = q;
        } else if (this.neighbor[p] == q && d > this.distance[p]) {
            this.findNeighbor(p);
        }
        if (d < this.distance[q]) {
            this.distance[q] = d;
            this.neighbor[q] = p;
        } else if (this.neighbor[q] == p && d > this.distance[q]) {
            this.findNeighbor(q);
        }
    }
}

