/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import smile.sort.QuickSort;

public class FPTree {
    int numTransactions = 0;
    int minSupport;
    Node root = new Node();
    int[] itemSupport;
    HeaderTableItem[] headerTable;
    int numItems = 0;
    int numFreqItems = 0;
    int maxItemSetSize = -1;
    int[] order;

    FPTree(int minSupport, int[] itemSupport) {
        this.itemSupport = itemSupport;
        this.minSupport = minSupport;
        this.init();
    }

    FPTree(int minSupport, Stream<int[]> itemsets) {
        this.itemSupport = this.freq(itemsets);
        this.minSupport = minSupport;
        this.init();
    }

    FPTree(double minSupport, Stream<int[]> itemsets) {
        this.itemSupport = this.freq(itemsets);
        this.minSupport = (int)Math.round(minSupport * (double)this.numTransactions);
        this.init();
    }

    private void init() {
        int i;
        this.numItems = this.itemSupport.length;
        for (int f : this.itemSupport) {
            if (f < this.minSupport) continue;
            ++this.numFreqItems;
        }
        this.headerTable = new HeaderTableItem[this.numFreqItems];
        int j = 0;
        for (i = 0; i < this.numItems; ++i) {
            if (this.itemSupport[i] < this.minSupport) continue;
            HeaderTableItem header = new HeaderTableItem(i);
            header.count = this.itemSupport[i];
            this.headerTable[j++] = header;
        }
        Arrays.sort(this.headerTable);
        this.order = new int[this.numItems];
        Arrays.fill(this.order, this.numItems);
        for (i = 0; i < this.numFreqItems; ++i) {
            this.order[this.headerTable[i].id] = i;
        }
    }

    private int[] freq(Stream<int[]> itemsets) {
        int n = Integer.parseInt(System.getProperty("smile.arm.items", "65536"));
        int[] f = new int[n];
        itemsets.forEach(itemset -> {
            ++this.numTransactions;
            int[] nArray = itemset;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int i2;
                int n2 = i2 = nArray[i];
                f[n2] = f[n2] + 1;
            }
        });
        while (f[--n] == 0) {
        }
        return Arrays.copyOf(f, n + 1);
    }

    public static FPTree of(int minSupport, Supplier<Stream<int[]>> supplier) {
        FPTree tree = new FPTree(minSupport, supplier.get());
        tree.add(supplier.get());
        return tree;
    }

    public static FPTree of(double minSupport, Supplier<Stream<int[]>> supplier) {
        FPTree tree = new FPTree(minSupport, supplier.get());
        tree.add(supplier.get());
        return tree;
    }

    public static FPTree of(int minSupport, int[][] itemsets) {
        FPTree tree = new FPTree(minSupport, Arrays.stream(itemsets));
        tree.add(Arrays.stream(itemsets));
        return tree;
    }

    public static FPTree of(double minSupport, int[][] itemsets) {
        FPTree tree = new FPTree(minSupport, Arrays.stream(itemsets));
        tree.add(Arrays.stream(itemsets));
        return tree;
    }

    public int size() {
        return this.numTransactions;
    }

    public int minSupport() {
        return this.minSupport;
    }

    private void add(Stream<int[]> itemsets) {
        itemsets.forEach(this::add);
    }

    private void add(int[] itemset) {
        int i;
        int m = 0;
        int t2 = itemset.length;
        int[] o = new int[t2];
        for (i = 0; i < t2; ++i) {
            int item = itemset[i];
            o[i] = this.order[item];
            if (this.itemSupport[item] < this.minSupport) continue;
            ++m;
        }
        if (m > 0) {
            QuickSort.sort(o, itemset, t2);
            for (i = 1; i < m; ++i) {
                if (itemset[i] != itemset[i - 1]) continue;
                --m;
                for (int j = i; j < m; ++j) {
                    itemset[j] = itemset[j + 1];
                }
            }
            this.root.add(0, m, itemset, 1);
        }
    }

    void add(int index, int end, int[] itemset, int support) {
        this.root.add(index, end, itemset, support);
    }

    class Node {
        int id = -1;
        int count = 0;
        Node parent = null;
        Node next = null;
        HashMap<Integer, Node> children = null;

        Node() {
        }

        Node(int id, int support, Node parent) {
            this.id = id;
            this.count = support;
            this.parent = parent;
        }

        void add(int index, int end, int[] itemset, int support) {
            Node child;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((child = this.children.get(itemset[index])) != null) {
                child.count += support;
                if (++index < end) {
                    child.add(index, end, itemset, support);
                }
            } else {
                this.append(index, end, itemset, support);
            }
        }

        void append(int index, int end, int[] itemset, int support) {
            if (this.children == null) {
                this.children = new HashMap();
            }
            if (index >= FPTree.this.maxItemSetSize) {
                FPTree.this.maxItemSetSize = index + 1;
            }
            int item = itemset[index];
            Node child = new Node(item, support, this.id < 0 ? null : this);
            child.addToHeaderTable();
            this.children.put(item, child);
            if (++index < end) {
                child.append(index, end, itemset, support);
            }
        }

        void addToHeaderTable() {
            this.next = FPTree.this.headerTable[FPTree.this.order[this.id]].node;
            FPTree.this.headerTable[FPTree.this.order[this.id]].node = this;
        }
    }

    static class HeaderTableItem
    implements Comparable<HeaderTableItem> {
        int id;
        int count = 0;
        Node node = null;

        HeaderTableItem(int id) {
            this.id = id;
        }

        @Override
        public int compareTo(HeaderTableItem o) {
            return Integer.compare(o.count, this.count);
        }
    }
}

