/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import smile.association.AssociationRule;
import smile.association.FPGrowth;
import smile.association.FPTree;
import smile.association.TotalSupportTree;

public class ARM
implements Iterable<AssociationRule> {
    private final int size;
    private final double confidence;
    private final TotalSupportTree ttree;
    private final Queue<AssociationRule> buffer = new LinkedList<AssociationRule>();

    ARM(double confidence, TotalSupportTree ttree) {
        this.size = ttree.size();
        this.confidence = confidence;
        this.ttree = ttree;
    }

    @Override
    public Iterator<AssociationRule> iterator() {
        return new Iterator<AssociationRule>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                if (ARM.this.buffer.isEmpty()) {
                    TotalSupportTree.Node root = ARM.this.ttree.root();
                    while (this.i < root.children.length) {
                        TotalSupportTree.Node child = root.children[this.i];
                        if (root.children[this.i] != null) {
                            int[] itemset = new int[]{child.id};
                            ARM.this.generate(itemset, this.i, child);
                            if (!ARM.this.buffer.isEmpty()) {
                                ++this.i;
                                break;
                            }
                        }
                        ++this.i;
                    }
                }
                return !ARM.this.buffer.isEmpty();
            }

            @Override
            public AssociationRule next() {
                return (AssociationRule)ARM.this.buffer.poll();
            }
        };
    }

    public static Stream<AssociationRule> apply(double confidence, FPTree tree) {
        TotalSupportTree ttree = new TotalSupportTree(tree);
        ARM arm = new ARM(confidence, ttree);
        return StreamSupport.stream(arm.spliterator(), false);
    }

    private void generate(int[] itemset, int size, TotalSupportTree.Node node) {
        if (node.children == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            if (node.children[i] == null) continue;
            int[] newItemset = FPGrowth.insert(itemset, node.children[i].id);
            this.generate(newItemset, node.children[i].support);
            this.generate(newItemset, i, node.children[i]);
        }
    }

    private void generate(int[] itemset, int support) {
        int[][] combinations;
        for (int[] combination : combinations = ARM.getPowerSet(itemset)) {
            double antecedentSupport;
            double arc;
            int[] complement = ARM.getComplement(combination, itemset);
            if (complement == null || !((arc = (double)support / (antecedentSupport = (double)this.ttree.getSupport(combination))) >= this.confidence)) continue;
            double supp = (double)support / (double)this.size;
            double consequentSupport = this.ttree.getSupport(complement);
            double lift = (double)support / (antecedentSupport * consequentSupport / (double)this.size);
            double leverage = supp - antecedentSupport / (double)this.size * (consequentSupport / (double)this.size);
            AssociationRule ar = new AssociationRule(combination, complement, supp, arc, lift, leverage);
            this.buffer.offer(ar);
        }
    }

    private static int[] getComplement(int[] subset, int[] fullset) {
        int size = fullset.length - subset.length;
        if (size < 1) {
            return null;
        }
        int[] complement = new int[size];
        int index = 0;
        for (int item : fullset) {
            boolean member = false;
            for (int i : subset) {
                if (item != i) continue;
                member = true;
                break;
            }
            if (member) continue;
            complement[index++] = item;
        }
        return complement;
    }

    private static int[][] getPowerSet(int[] set) {
        int[][] sets = new int[ARM.getPowerSetSize(set.length)][];
        ARM.getPowerSet(set, 0, null, sets, 0);
        return sets;
    }

    private static int getPowerSet(int[] set, int inputIndex, int[] sofar, int[][] sets, int outputIndex) {
        for (int i = inputIndex; i < set.length; ++i) {
            int n;
            int n2 = n = sofar == null ? 0 : sofar.length;
            if (n >= set.length - 1) continue;
            int[] subset = new int[n + 1];
            subset[n] = set[i];
            if (sofar != null) {
                System.arraycopy(sofar, 0, subset, 0, n);
            }
            sets[outputIndex] = subset;
            outputIndex = ARM.getPowerSet(set, i + 1, subset, sets, outputIndex + 1);
        }
        return outputIndex;
    }

    private static int getPowerSetSize(int n) {
        return (int)Math.pow(2.0, n) - 2;
    }
}

