/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import org.apache.commons.math3.exception.NumberIsTooSmallException;
import ro.hasna.ts.math.exception.ArrayLengthIsTooSmallException;
import ro.hasna.ts.math.representation.GenericTransformer;

public class PiecewiseAggregateApproximation
implements GenericTransformer<double[], double[]> {
    private static final long serialVersionUID = -8199587096227874425L;
    private final int segments;

    public PiecewiseAggregateApproximation(int segments) {
        if (segments < 1) {
            throw new NumberIsTooSmallException(segments, (Number)1, true);
        }
        this.segments = segments;
    }

    @Override
    public double[] transform(double[] values) {
        int len = values.length;
        if (len < this.segments) {
            throw new ArrayLengthIsTooSmallException(len, (Number)this.segments, true);
        }
        int modulo = len % this.segments;
        double[] reducedValues = new double[this.segments];
        if (modulo == 0) {
            int segmentSize = len / this.segments;
            double sum = 0.0;
            int n = 0;
            for (int i = 0; i < len; ++i) {
                sum += values[i];
                if ((i + 1) % segmentSize != 0) continue;
                reducedValues[n++] = sum / (double)segmentSize;
                if (n != this.segments) {
                    sum = 0.0;
                    continue;
                }
                break;
            }
        } else {
            double segmentSize = (double)len * 1.0 / (double)this.segments;
            int k = 0;
            double sum = 0.0;
            for (int i = 0; i < this.segments - 1; ++i) {
                double x = (double)(i + 1) * segmentSize - 1.0;
                while ((double)k < x) {
                    sum += values[k];
                    ++k;
                }
                double delta = x - (double)((int)x);
                reducedValues[i] = (sum += delta * values[k]) / segmentSize;
                sum = (1.0 - delta) * values[k];
                ++k;
            }
            while (k < len) {
                sum += values[k];
                ++k;
            }
            reducedValues[this.segments - 1] = sum / segmentSize;
        }
        return reducedValues;
    }

    public int getSegments() {
        return this.segments;
    }
}

