/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.representation.GenericTransformer;

public class DiscreteChebyshevTransform
implements GenericTransformer<double[], double[]> {
    private static final long serialVersionUID = 574122627898745036L;
    private final FastFourierTransformer fourierTransformer;

    public DiscreteChebyshevTransform() {
        this(new FastFourierTransformer(DftNormalization.STANDARD));
    }

    public DiscreteChebyshevTransform(FastFourierTransformer fourierTransformer) {
        this.fourierTransformer = fourierTransformer;
    }

    @Override
    public double[] transform(double[] values) {
        int length = values.length;
        if (length < 3) {
            int n = length - 1;
            double[] result = new double[length];
            for (int i = 0; i <= n; ++i) {
                double sum = 0.0;
                for (int j = 0; j <= n; ++j) {
                    if (j == 0 || j == n) {
                        sum += values[j] * FastMath.cos((double)(i * j) * Math.PI / (double)n) / 2.0;
                        continue;
                    }
                    sum += values[j] * FastMath.cos((double)(i * j) * Math.PI / (double)n);
                }
                result[i] = i == 0 || i == n ? sum / (double)n : sum * 2.0 / (double)n;
            }
            return result;
        }
        int end = length * 2 - 2;
        int powerOfTwo = Integer.highestOneBit(end);
        if (end != powerOfTwo) {
            powerOfTwo <<= 1;
        }
        double[] copy = new double[powerOfTwo];
        System.arraycopy(values, 0, copy, 0, length);
        for (int i = 1; i < length - 1; ++i) {
            copy[end - i] = values[i];
        }
        Complex[] complexes = this.fourierTransformer.transform(copy, TransformType.FORWARD);
        double[] result = new double[length];
        result[0] = complexes[0].getReal() / (double)powerOfTwo;
        for (int i = 1; i < length && i < complexes.length; ++i) {
            result[i] = 2.0 * complexes[i].getReal() / (double)powerOfTwo;
        }
        int n = length - 1;
        result[n] = result[n] / 2.0;
        return result;
    }
}

