/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.jobs.ee.jms.JmsHelper;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public final class SendDestinationMessageJob
implements Job {
    @Override
    public void execute(JobExecutionContext jobCtx) throws JobExecutionException {
        Connection conn = null;
        Session sess = null;
        MessageProducer producer = null;
        try {
            JobDataMap dataMap = jobCtx.getMergedJobDataMap();
            InitialContext namingCtx = JmsHelper.getInitialContext(dataMap);
            ConnectionFactory connFactory = (ConnectionFactory)namingCtx.lookup(dataMap.getString("jms.connection.factory"));
            if (!JmsHelper.isDestinationSecure(dataMap)) {
                conn = connFactory.createConnection();
            } else {
                String user = dataMap.getString("jms.user");
                String password = dataMap.getString("jms.password");
                conn = connFactory.createConnection(user, password);
            }
            boolean useTransaction = JmsHelper.useTransaction(dataMap);
            int ackMode = dataMap.getInt("jms.acknowledge");
            sess = conn.createSession(useTransaction, ackMode);
            Destination destination = (Destination)namingCtx.lookup(dataMap.getString("jms.destination"));
            producer = sess.createProducer(destination);
            JmsMessageFactory messageFactory = JmsHelper.getMessageFactory(dataMap.getString("jms.message.factory.class.name"));
            Message msg = messageFactory.createMessage(dataMap, sess);
            producer.send(msg);
        }
        catch (Exception e) {
            try {
                throw new JobExecutionException(e);
            }
            catch (Throwable throwable) {
                JmsHelper.closeResource(producer);
                JmsHelper.closeResource(sess);
                JmsHelper.closeResource(conn);
                throw throwable;
            }
        }
        JmsHelper.closeResource(producer);
        JmsHelper.closeResource(sess);
        JmsHelper.closeResource(conn);
    }
}

