/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.timelines;

import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.MeasurementsVector;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineReader;
import io.intino.sumus.chronos.timelines.blocks.Header;
import io.intino.sumus.chronos.timelines.blocks.SensorModel;
import io.intino.sumus.chronos.timelines.blocks.TimeModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.channels.SeekableByteChannel;
import java.time.Instant;
import java.util.Collection;

public class TimelineWriter
implements AutoCloseable {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private final SeekableByteChannel channel;
    private ByteBuffer buffer;
    private int dataBlockPosition;
    private final Header header;
    private TimelineStore.SensorModel sensorModel;
    private TimelineStore.TimeModel timeModel;
    private boolean shouldWriteSensorModel;
    private boolean shouldWriteTimeModel;

    public TimelineWriter(String sensor, SeekableByteChannel channel) throws IOException {
        this(sensor, channel, 32768);
    }

    public TimelineWriter(String sensor, SeekableByteChannel channel, int bufferSize) throws IOException {
        this.channel = channel;
        this.header = new Header(sensor);
        this.buffer = ByteBuffer.allocate(Math.max(bufferSize, 1024));
        this.reserveOrReadHeader();
    }

    public Header header() {
        return this.header;
    }

    public TimelineStore.SensorModel sensorModel() {
        return this.sensorModel;
    }

    public TimelineStore.TimeModel timeModel() {
        return this.timeModel;
    }

    public Instant threshold() {
        return this.timeModel == null || this.header.next() == null ? Instant.EPOCH : this.timeModel.next(this.header.next());
    }

    private void reserveOrReadHeader() throws IOException {
        if (this.channel.position() == 0L) {
            this.reserveHeader();
        } else {
            this.readHeader();
        }
    }

    public TimelineWriter sensorModel(TimelineStore.SensorModel sensorModel) throws IOException {
        if (this.sensorModel != null && this.sensorModel.contains(sensorModel)) {
            return this;
        }
        this.sensorModel = sensorModel;
        this.shouldWriteSensorModel = true;
        return this;
    }

    public TimelineWriter sensorModel(String ... magnitudes) throws IOException {
        return this.sensorModel(new SensorModel(magnitudes));
    }

    public TimelineWriter sensorModel(Magnitude ... magnitudes) throws IOException {
        return this.sensorModel(new SensorModel(magnitudes));
    }

    public TimelineWriter timeModel(TimelineStore.TimeModel timeModel) throws IOException {
        if (timeModel.equals(this.timeModel)) {
            return this;
        }
        this.timeModel = timeModel;
        this.shouldWriteTimeModel = true;
        return this;
    }

    public TimelineWriter timeModel(Instant instant, Period period) throws IOException {
        return this.timeModel(new TimeModel(instant, period));
    }

    public TimelineWriter set(Instant instant) throws IOException {
        if (instant.isBefore(this.threshold())) {
            return this;
        }
        return this.timeModel(new TimeModel(instant, this.timeModel.period()));
    }

    public TimelineWriter set(MeasurementsVector measurementsVector) throws IOException {
        return this.set(measurementsVector.toArray());
    }

    public TimelineWriter set(double[] values) throws IOException {
        return this.set(values, 0, values.length);
    }

    public TimelineWriter set(double[] values, int offset, int length) throws IOException {
        this.ensureCapacityOrFlush(length * 8);
        this.beginDataBlock();
        for (int i = 0; i < length; ++i) {
            this.buffer.putDouble(values[offset + i]);
        }
        this.header.step(this.timeModel);
        return this;
    }

    public TimelineWriter set(Collection<Number> values) throws IOException {
        this.ensureCapacityOrFlush(values.size() * 8);
        this.beginDataBlock();
        for (Number n : values) {
            this.buffer.putDouble(n.doubleValue());
        }
        this.header.step(this.timeModel);
        return this;
    }

    public TimelineWriter set(ByteBuffer values) throws IOException {
        this.ensureCapacityOrFlush(values.remaining());
        this.beginDataBlock();
        this.put(values);
        this.header.step(this.timeModel);
        return this;
    }

    public TimelineWriter set(DoubleBuffer values) throws IOException {
        int numBytes = values.remaining() * 8;
        this.ensureCapacityOrFlush(numBytes);
        this.beginDataBlock();
        this.buffer.asDoubleBuffer().put(values);
        this.buffer.position(this.buffer.position() + numBytes);
        this.header.step(this.timeModel);
        return this;
    }

    private void ensureCapacityOrFlush(int bytes) throws IOException {
        if (this.dataBlockPosition <= 0) {
            bytes += 6;
        }
        if (bytes > this.buffer.remaining()) {
            this.flush();
        }
    }

    private void beginDataBlock() throws IOException {
        this.writeSensorAndTimeModel();
        if (this.dataBlockPosition > 0) {
            return;
        }
        this.buffer.putShort((short)21845);
        this.buffer.putInt(0);
        this.dataBlockPosition = this.buffer.position();
    }

    private void writeSensorAndTimeModel() throws IOException {
        boolean written = false;
        if (this.shouldWriteSensorModel) {
            this.writeSensorModel();
            written = true;
        }
        if (this.shouldWriteTimeModel) {
            this.writeTimeModel();
            written = true;
        }
        if (written && this.buffer.remaining() < this.sensorModel.size() * 8) {
            this.flush();
        }
    }

    private void endDataBlock() {
        if (this.dataBlockPosition <= 0) {
            return;
        }
        this.buffer.putInt(this.dataBlockPosition - 4, this.buffer.position() - this.dataBlockPosition);
        this.dataBlockPosition = 0;
    }

    public void flush() throws IOException {
        if (this.buffer == null || this.buffer.position() == 0) {
            return;
        }
        this.endDataBlock();
        this.commit(this.buffer.flip());
    }

    @Override
    public void close() throws IOException {
        if (!this.channel.isOpen()) {
            return;
        }
        this.writeSensorAndTimeModel();
        this.endDataBlock();
        this.flush();
        this.writeHeader();
        this.channel.close();
        this.buffer = null;
    }

    private void writeHeader() throws IOException {
        this.channel.position(0L);
        this.commit(Header.serialize(this.header));
        this.channel.position(this.channel.size());
    }

    private void writeTimeModel() throws IOException {
        this.header.setTimeModel(this.currentPosition(), this.timeModel);
        this.endDataBlock();
        ByteBuffer timeModelBytes = TimeModel.serialize(this.timeModel);
        this.ensureCapacityOrFlush(timeModelBytes.remaining());
        this.put(timeModelBytes);
        this.shouldWriteTimeModel = false;
    }

    private void writeSensorModel() throws IOException {
        this.header.setSensorModel(this.currentPosition());
        this.endDataBlock();
        ByteBuffer sensorModelBytes = SensorModel.serialize(this.sensorModel);
        this.ensureCapacityOrFlush(sensorModelBytes.remaining());
        this.put(sensorModelBytes);
        this.shouldWriteSensorModel = false;
    }

    private void commit(ByteBuffer buffer) throws IOException {
        this.channel.write(buffer);
        buffer.clear();
    }

    private void reserveHeader() throws IOException {
        this.channel.position(512L);
    }

    private void readHeader() throws IOException {
        this.channel.position(0L);
        TimelineReader.readHeader(this.channel, this.header);
        this.sensorModel = TimelineReader.readSensorModel(this.header.sensorModelPosition, this.channel);
        this.timeModel = TimelineReader.readTimeModel(this.header.timeModelPosition, this.channel);
        this.channel.position(this.channel.size());
    }

    private long currentPosition() throws IOException {
        return this.channel.position() + (long)this.buffer.position();
    }

    private void put(ByteBuffer values) throws IOException {
        int originalLimit = values.limit();
        while (values.hasRemaining()) {
            values.limit(Math.min(values.position() + this.buffer.limit(), originalLimit));
            this.ensureCapacityOrFlush(values.remaining());
            this.buffer.put(values);
            values.limit(originalLimit);
        }
    }
}

