/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.Json;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.ingestion.EventSession;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.JmsConnector;
import io.intino.alexandria.terminal.remotedatalake.RemoteDatalake;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamartImpl;
import io.intino.cosmos.datahub.measurements.analysis.Analysis;
import io.intino.cosmos.datahub.measurements.monitoring.Application;
import io.intino.cosmos.datahub.measurements.monitoring.Camera;
import io.intino.cosmos.datahub.measurements.monitoring.CellularGateway;
import io.intino.cosmos.datahub.measurements.monitoring.Computer;
import io.intino.cosmos.datahub.measurements.monitoring.Switch;
import io.intino.cosmos.datahub.measurements.monitoring.Wireless;
import io.intino.cosmos.datahub.messages.monitoring.Incident;
import io.intino.cosmos.datahub.messages.monitoring.IncidentFinished;
import io.intino.cosmos.datahub.messages.monitoring.Status;
import io.intino.cosmos.datahub.messages.universe.ApplianceAssertion;
import io.intino.cosmos.datahub.messages.universe.ApplicationAssertion;
import io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion;
import io.intino.cosmos.datahub.messages.universe.AreaAssertion;
import io.intino.cosmos.datahub.messages.universe.AssetAssertion;
import io.intino.cosmos.datahub.messages.universe.ComputerAssertion;
import io.intino.cosmos.datahub.messages.universe.CountermeasureAssertion;
import io.intino.cosmos.datahub.messages.universe.HardwareAssertion;
import io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion;
import io.intino.cosmos.datahub.messages.universe.ModelAssertion;
import io.intino.cosmos.datahub.messages.universe.ObserverAssertion;
import io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion;
import io.intino.cosmos.datahub.messages.universe.PartAssertion;
import io.intino.cosmos.datahub.messages.universe.PersonAssertion;
import io.intino.cosmos.datahub.messages.universe.PlaceAssertion;
import io.intino.cosmos.datahub.messages.universe.ProcessAssertion;
import io.intino.cosmos.datahub.messages.universe.ServiceAssertion;
import io.intino.cosmos.datahub.messages.universe.SoftwareAssertion;
import io.intino.cosmos.datahub.messages.universe.TagAssertion;
import io.intino.cosmos.datahub.resources.monitoring.Log;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.activemq.command.ActiveMQTextMessage;

public class ObserverTerminal {
    public static String[] subscriptionChannels = new String[0];
    private final Connector connector;
    private final Set<BiConsumer> datamartConsumers = new HashSet<BiConsumer>();
    private volatile Datalake datalake;
    private final DatamartsRetryConfig datamartsRetryConfig;
    private String sourceSelector;
    private final Map<BiConsumer<?, String>, List<Consumer<Event>>> consumers = new HashMap();
    private volatile MasterDatamartImpl datamart;
    private final Object monitor = new Object();

    public ObserverTerminal(Connector connector) {
        this(connector, new DatamartsRetryConfig());
    }

    public ObserverTerminal(Connector connector, DatamartsRetryConfig datamartsRetryConfig) {
        this.connector = connector;
        this.datamartsRetryConfig = datamartsRetryConfig;
        this.datamart = new MasterDatamartImpl(connector, datamartsRetryConfig);
    }

    public MasterDatamart datamart() {
        return this.datamart;
    }

    public void initDatamarts() {
        this.initDatamarts(null);
    }

    public void initDatamarts(String sourceSelector) {
        this.sourceSelector = sourceSelector;
        this.datamart.init(sourceSelector);
        this.addDatamartSubscribers(sourceSelector);
    }

    public void publish(Event event) {
        switch (event.type()) {
            case "Status": {
                Status e;
                this.publish(event instanceof Status ? (e = (Status)event) : new Status(((MessageEvent)event).toMessage()));
                break;
            }
            case "Incident": {
                Incident e;
                this.publish(event instanceof Incident ? (e = (Incident)event) : new Incident(((MessageEvent)event).toMessage()));
                break;
            }
            case "IncidentFinished": {
                IncidentFinished e;
                this.publish(event instanceof IncidentFinished ? (e = (IncidentFinished)event) : new IncidentFinished(((MessageEvent)event).toMessage()));
                break;
            }
            case "PlaceAssertion": {
                PlaceAssertion e;
                this.publish(event instanceof PlaceAssertion ? (e = (PlaceAssertion)event) : new PlaceAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "AreaAssertion": {
                AreaAssertion e;
                this.publish(event instanceof AreaAssertion ? (e = (AreaAssertion)event) : new AreaAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "ModelAssertion": {
                ModelAssertion e;
                this.publish(event instanceof ModelAssertion ? (e = (ModelAssertion)event) : new ModelAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "OrderTypeAssertion": {
                OrderTypeAssertion e;
                this.publish(event instanceof OrderTypeAssertion ? (e = (OrderTypeAssertion)event) : new OrderTypeAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "PersonAssertion": {
                PersonAssertion e;
                this.publish(event instanceof PersonAssertion ? (e = (PersonAssertion)event) : new PersonAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "ProcessAssertion": {
                ProcessAssertion e;
                this.publish(event instanceof ProcessAssertion ? (e = (ProcessAssertion)event) : new ProcessAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "AssetAssertion": {
                AssetAssertion e;
                this.publish(event instanceof AssetAssertion ? (e = (AssetAssertion)event) : new AssetAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "PartAssertion": {
                PartAssertion e;
                this.publish(event instanceof PartAssertion ? (e = (PartAssertion)event) : new PartAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "HardwareAssertion": {
                HardwareAssertion e;
                this.publish(event instanceof HardwareAssertion ? (e = (HardwareAssertion)event) : new HardwareAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "ComputerAssertion": {
                ComputerAssertion e;
                this.publish(event instanceof ComputerAssertion ? (e = (ComputerAssertion)event) : new ComputerAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "ApplianceAssertion": {
                ApplianceAssertion e;
                this.publish(event instanceof ApplianceAssertion ? (e = (ApplianceAssertion)event) : new ApplianceAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "SoftwareAssertion": {
                SoftwareAssertion e;
                this.publish(event instanceof SoftwareAssertion ? (e = (SoftwareAssertion)event) : new SoftwareAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "ObserverAssertion": {
                ObserverAssertion e;
                this.publish(event instanceof ObserverAssertion ? (e = (ObserverAssertion)event) : new ObserverAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "ApplicationAssertion": {
                ApplicationAssertion e;
                this.publish(event instanceof ApplicationAssertion ? (e = (ApplicationAssertion)event) : new ApplicationAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "ApplicationJavaAssertion": {
                ApplicationJavaAssertion e;
                this.publish(event instanceof ApplicationJavaAssertion ? (e = (ApplicationJavaAssertion)event) : new ApplicationJavaAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "ServiceAssertion": {
                ServiceAssertion e;
                this.publish(event instanceof ServiceAssertion ? (e = (ServiceAssertion)event) : new ServiceAssertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "Computer": {
                Computer e;
                this.publish(event instanceof Computer ? (e = (Computer)event) : new Computer(((MessageEvent)event).toMessage()));
                break;
            }
            case "Application": {
                Application e;
                this.publish(event instanceof Application ? (e = (Application)event) : new Application(((MessageEvent)event).toMessage()));
                break;
            }
            case "Camera": {
                Camera e;
                this.publish(event instanceof Camera ? (e = (Camera)event) : new Camera(((MessageEvent)event).toMessage()));
                break;
            }
            case "CellularGateway": {
                CellularGateway e;
                this.publish(event instanceof CellularGateway ? (e = (CellularGateway)event) : new CellularGateway(((MessageEvent)event).toMessage()));
                break;
            }
            case "Switch": {
                Switch e;
                this.publish(event instanceof Switch ? (e = (Switch)event) : new Switch(((MessageEvent)event).toMessage()));
                break;
            }
            case "Wireless": {
                Wireless e;
                this.publish(event instanceof Wireless ? (e = (Wireless)event) : new Wireless(((MessageEvent)event).toMessage()));
                break;
            }
            case "Log": {
                this.publish((Log)event);
                break;
            }
            default: {
                Logger.warn(this.getClass().getSimpleName() + " is not configured to publish " + event.type() + " events.");
            }
        }
    }

    public void publish(Event first, Event ... others) {
        this.publish(Stream.concat(Stream.of(first), Arrays.stream(others)));
    }

    public void publish(Event[] events) {
        this.publish(Arrays.stream(events));
    }

    public void publish(Collection<Event> events) {
        this.publish(events.stream());
    }

    public void publish(Stream<Event> events) {
        events.filter(e -> this.channelOf(e.type()) != null).collect(Collectors.groupingBy(Event::type)).forEach((type, eventList) -> this.connector.sendEvents(this.channelOf((String)type), (List<Event>)eventList));
    }

    public synchronized Datalake datalake() {
        return this.datalake != null ? this.datalake : (this.datalake = this.instantiateDatalake());
    }

    private Datalake instantiateDatalake() {
        try {
            Message message = this.connector.requestResponse("service.ness.datalake", this.request("Datalake"), 5L, TimeUnit.SECONDS);
            if (message == null) {
                return null;
            }
            String path = ((TextMessage)message).getText();
            if (path == null) {
                return null;
            }
            return new File(path).exists() ? new FileDatalake(new File(path)) : new RemoteDatalake((JmsConnector)this.connector);
        }
        catch (JMSException e) {
            Logger.error(e);
            return null;
        }
    }

    public BatchSession batch(File temporalStageDirectory) {
        return new BatchSession(temporalStageDirectory);
    }

    public BatchSession batch(File temporalStageDirectory, Config config) {
        return new BatchSession(temporalStageDirectory, config);
    }

    public void publish(Status e) {
        this.connector.sendEvent("monitoring.Status", e);
    }

    public void publish(Status first, Status ... others) {
        Status[] array = new Status[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(Status[] events) {
        this.connector.sendEvents("monitoring.Status", Arrays.asList(events));
    }

    public void publish(Incident e) {
        this.connector.sendEvent("monitoring.Incident", e);
    }

    public void publish(Incident first, Incident ... others) {
        Incident[] array = new Incident[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(Incident[] events) {
        this.connector.sendEvents("monitoring.Incident", Arrays.asList(events));
    }

    public void publish(IncidentFinished e) {
        this.connector.sendEvent("monitoring.IncidentFinished", e);
    }

    public void publish(IncidentFinished first, IncidentFinished ... others) {
        IncidentFinished[] array = new IncidentFinished[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(IncidentFinished[] events) {
        this.connector.sendEvents("monitoring.IncidentFinished", Arrays.asList(events));
    }

    public void publish(PlaceAssertion e) {
        this.connector.sendEvent("universe.PlaceAssertion", e);
    }

    public void publish(PlaceAssertion first, PlaceAssertion ... others) {
        PlaceAssertion[] array = new PlaceAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(PlaceAssertion[] events) {
        this.connector.sendEvents("universe.PlaceAssertion", Arrays.asList(events));
    }

    public void publish(AreaAssertion e) {
        this.connector.sendEvent("universe.AreaAssertion", e);
    }

    public void publish(AreaAssertion first, AreaAssertion ... others) {
        AreaAssertion[] array = new AreaAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(AreaAssertion[] events) {
        this.connector.sendEvents("universe.AreaAssertion", Arrays.asList(events));
    }

    public void publish(ModelAssertion e) {
        this.connector.sendEvent("universe.ModelAssertion", e);
    }

    public void publish(ModelAssertion first, ModelAssertion ... others) {
        ModelAssertion[] array = new ModelAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(ModelAssertion[] events) {
        this.connector.sendEvents("universe.ModelAssertion", Arrays.asList(events));
    }

    public void publish(OrderTypeAssertion e) {
        this.connector.sendEvent("universe.OrderTypeAssertion", e);
    }

    public void publish(OrderTypeAssertion first, OrderTypeAssertion ... others) {
        OrderTypeAssertion[] array = new OrderTypeAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(OrderTypeAssertion[] events) {
        this.connector.sendEvents("universe.OrderTypeAssertion", Arrays.asList(events));
    }

    public void publish(PersonAssertion e) {
        this.connector.sendEvent("universe.PersonAssertion", e);
    }

    public void publish(PersonAssertion first, PersonAssertion ... others) {
        PersonAssertion[] array = new PersonAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(PersonAssertion[] events) {
        this.connector.sendEvents("universe.PersonAssertion", Arrays.asList(events));
    }

    public void publish(ProcessAssertion e) {
        this.connector.sendEvent("universe.ProcessAssertion", e);
    }

    public void publish(ProcessAssertion first, ProcessAssertion ... others) {
        ProcessAssertion[] array = new ProcessAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(ProcessAssertion[] events) {
        this.connector.sendEvents("universe.ProcessAssertion", Arrays.asList(events));
    }

    public void publish(AssetAssertion e) {
        this.connector.sendEvent("universe.AssetAssertion", e);
    }

    public void publish(AssetAssertion first, AssetAssertion ... others) {
        AssetAssertion[] array = new AssetAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(AssetAssertion[] events) {
        this.connector.sendEvents("universe.AssetAssertion", Arrays.asList(events));
    }

    public void publish(PartAssertion e) {
        this.connector.sendEvent("universe.PartAssertion", e);
    }

    public void publish(PartAssertion first, PartAssertion ... others) {
        PartAssertion[] array = new PartAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(PartAssertion[] events) {
        this.connector.sendEvents("universe.PartAssertion", Arrays.asList(events));
    }

    public void publish(HardwareAssertion e) {
        this.connector.sendEvent("universe.HardwareAssertion", e);
    }

    public void publish(HardwareAssertion first, HardwareAssertion ... others) {
        HardwareAssertion[] array = new HardwareAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(HardwareAssertion[] events) {
        this.connector.sendEvents("universe.HardwareAssertion", Arrays.asList(events));
    }

    public void publish(ComputerAssertion e) {
        this.connector.sendEvent("universe.ComputerAssertion", e);
    }

    public void publish(ComputerAssertion first, ComputerAssertion ... others) {
        ComputerAssertion[] array = new ComputerAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(ComputerAssertion[] events) {
        this.connector.sendEvents("universe.ComputerAssertion", Arrays.asList(events));
    }

    public void publish(ApplianceAssertion e) {
        this.connector.sendEvent("universe.ApplianceAssertion", e);
    }

    public void publish(ApplianceAssertion first, ApplianceAssertion ... others) {
        ApplianceAssertion[] array = new ApplianceAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(ApplianceAssertion[] events) {
        this.connector.sendEvents("universe.ApplianceAssertion", Arrays.asList(events));
    }

    public void publish(SoftwareAssertion e) {
        this.connector.sendEvent("universe.SoftwareAssertion", e);
    }

    public void publish(SoftwareAssertion first, SoftwareAssertion ... others) {
        SoftwareAssertion[] array = new SoftwareAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(SoftwareAssertion[] events) {
        this.connector.sendEvents("universe.SoftwareAssertion", Arrays.asList(events));
    }

    public void publish(ObserverAssertion e) {
        this.connector.sendEvent("universe.ObserverAssertion", e);
    }

    public void publish(ObserverAssertion first, ObserverAssertion ... others) {
        ObserverAssertion[] array = new ObserverAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(ObserverAssertion[] events) {
        this.connector.sendEvents("universe.ObserverAssertion", Arrays.asList(events));
    }

    public void publish(ApplicationAssertion e) {
        this.connector.sendEvent("universe.ApplicationAssertion", e);
    }

    public void publish(ApplicationAssertion first, ApplicationAssertion ... others) {
        ApplicationAssertion[] array = new ApplicationAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(ApplicationAssertion[] events) {
        this.connector.sendEvents("universe.ApplicationAssertion", Arrays.asList(events));
    }

    public void publish(ApplicationJavaAssertion e) {
        this.connector.sendEvent("universe.ApplicationJavaAssertion", e);
    }

    public void publish(ApplicationJavaAssertion first, ApplicationJavaAssertion ... others) {
        ApplicationJavaAssertion[] array = new ApplicationJavaAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(ApplicationJavaAssertion[] events) {
        this.connector.sendEvents("universe.ApplicationJavaAssertion", Arrays.asList(events));
    }

    public void publish(ServiceAssertion e) {
        this.connector.sendEvent("universe.ServiceAssertion", e);
    }

    public void publish(ServiceAssertion first, ServiceAssertion ... others) {
        ServiceAssertion[] array = new ServiceAssertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(ServiceAssertion[] events) {
        this.connector.sendEvents("universe.ServiceAssertion", Arrays.asList(events));
    }

    public void publish(Computer e) {
        this.connector.sendEvent("monitoring.Computer", e);
    }

    public void publish(Application e) {
        this.connector.sendEvent("monitoring.Application", e);
    }

    public void publish(Camera e) {
        this.connector.sendEvent("monitoring.Camera", e);
    }

    public void publish(CellularGateway e) {
        this.connector.sendEvent("monitoring.CellularGateway", e);
    }

    public void publish(Switch e) {
        this.connector.sendEvent("monitoring.Switch", e);
    }

    public void publish(Wireless e) {
        this.connector.sendEvent("monitoring.Wireless", e);
    }

    public void publish(Log e) {
        this.connector.sendEvent("monitoring.Log", e);
    }

    public void publish(Log first, Log ... others) {
        Log[] array = new Log[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(Log[] events) {
        this.connector.sendEvents("monitoring.Log", Arrays.asList(events));
    }

    public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PlaceAssertion((MessageEvent)event), "universe.PlaceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PlaceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PlaceAssertion((MessageEvent)event), "universe.PlaceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PlaceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PlaceAssertion((MessageEvent)event), "universe.PlaceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PlaceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniversePlaceAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PlaceAssertion((MessageEvent)event), "universe.PlaceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PlaceAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniversePlaceAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AreaAssertion((MessageEvent)event), "universe.AreaAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.AreaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AreaAssertion((MessageEvent)event), "universe.AreaAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.AreaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AreaAssertion((MessageEvent)event), "universe.AreaAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.AreaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseAreaAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AreaAssertion((MessageEvent)event), "universe.AreaAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.AreaAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseAreaAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseTagAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new TagAssertion((MessageEvent)event), "universe.TagAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.TagAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseTagAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new TagAssertion((MessageEvent)event), "universe.TagAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.TagAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseTagAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new TagAssertion((MessageEvent)event), "universe.TagAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.TagAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseTagAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new TagAssertion((MessageEvent)event), "universe.TagAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.TagAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseTagAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentRuleAssertion((MessageEvent)event), "universe.IncidentRuleAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.IncidentRuleAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentRuleAssertion((MessageEvent)event), "universe.IncidentRuleAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.IncidentRuleAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentRuleAssertion((MessageEvent)event), "universe.IncidentRuleAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.IncidentRuleAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentRuleAssertion((MessageEvent)event), "universe.IncidentRuleAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.IncidentRuleAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseIncidentRuleAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new CountermeasureAssertion((MessageEvent)event), "universe.CountermeasureAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.CountermeasureAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new CountermeasureAssertion((MessageEvent)event), "universe.CountermeasureAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.CountermeasureAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new CountermeasureAssertion((MessageEvent)event), "universe.CountermeasureAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.CountermeasureAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseCountermeasureAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new CountermeasureAssertion((MessageEvent)event), "universe.CountermeasureAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.CountermeasureAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseCountermeasureAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ModelAssertion((MessageEvent)event), "universe.ModelAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ModelAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ModelAssertion((MessageEvent)event), "universe.ModelAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ModelAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ModelAssertion((MessageEvent)event), "universe.ModelAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ModelAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseModelAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ModelAssertion((MessageEvent)event), "universe.ModelAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ModelAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseModelAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new OrderTypeAssertion((MessageEvent)event), "universe.OrderTypeAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.OrderTypeAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new OrderTypeAssertion((MessageEvent)event), "universe.OrderTypeAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.OrderTypeAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new OrderTypeAssertion((MessageEvent)event), "universe.OrderTypeAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.OrderTypeAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new OrderTypeAssertion((MessageEvent)event), "universe.OrderTypeAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.OrderTypeAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseOrderTypeAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PersonAssertion((MessageEvent)event), "universe.PersonAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PersonAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PersonAssertion((MessageEvent)event), "universe.PersonAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PersonAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PersonAssertion((MessageEvent)event), "universe.PersonAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PersonAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniversePersonAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PersonAssertion((MessageEvent)event), "universe.PersonAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PersonAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniversePersonAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessAssertion((MessageEvent)event), "universe.ProcessAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ProcessAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessAssertion((MessageEvent)event), "universe.ProcessAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ProcessAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessAssertion((MessageEvent)event), "universe.ProcessAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ProcessAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseProcessAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessAssertion((MessageEvent)event), "universe.ProcessAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ProcessAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseProcessAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AssetAssertion((MessageEvent)event), "universe.AssetAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.AssetAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AssetAssertion((MessageEvent)event), "universe.AssetAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.AssetAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AssetAssertion((MessageEvent)event), "universe.AssetAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.AssetAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseAssetAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AssetAssertion((MessageEvent)event), "universe.AssetAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.AssetAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseAssetAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PartAssertion((MessageEvent)event), "universe.PartAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PartAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PartAssertion((MessageEvent)event), "universe.PartAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PartAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PartAssertion((MessageEvent)event), "universe.PartAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PartAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniversePartAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PartAssertion((MessageEvent)event), "universe.PartAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.PartAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniversePartAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new HardwareAssertion((MessageEvent)event), "universe.HardwareAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.HardwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new HardwareAssertion((MessageEvent)event), "universe.HardwareAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.HardwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new HardwareAssertion((MessageEvent)event), "universe.HardwareAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.HardwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseHardwareAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new HardwareAssertion((MessageEvent)event), "universe.HardwareAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.HardwareAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseHardwareAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplianceAssertion((MessageEvent)event), "universe.ApplianceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplianceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplianceAssertion((MessageEvent)event), "universe.ApplianceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplianceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplianceAssertion((MessageEvent)event), "universe.ApplianceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplianceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseApplianceAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplianceAssertion((MessageEvent)event), "universe.ApplianceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplianceAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseApplianceAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ComputerAssertion((MessageEvent)event), "universe.ComputerAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ComputerAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ComputerAssertion((MessageEvent)event), "universe.ComputerAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ComputerAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ComputerAssertion((MessageEvent)event), "universe.ComputerAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ComputerAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseComputerAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ComputerAssertion((MessageEvent)event), "universe.ComputerAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ComputerAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseComputerAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new SoftwareAssertion((MessageEvent)event), "universe.SoftwareAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.SoftwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new SoftwareAssertion((MessageEvent)event), "universe.SoftwareAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.SoftwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new SoftwareAssertion((MessageEvent)event), "universe.SoftwareAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.SoftwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new SoftwareAssertion((MessageEvent)event), "universe.SoftwareAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.SoftwareAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseSoftwareAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ObserverAssertion((MessageEvent)event), "universe.ObserverAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ObserverAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ObserverAssertion((MessageEvent)event), "universe.ObserverAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ObserverAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ObserverAssertion((MessageEvent)event), "universe.ObserverAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ObserverAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseObserverAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ObserverAssertion((MessageEvent)event), "universe.ObserverAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ObserverAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseObserverAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServiceAssertion((MessageEvent)event), "universe.ServiceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ServiceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServiceAssertion((MessageEvent)event), "universe.ServiceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ServiceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServiceAssertion((MessageEvent)event), "universe.ServiceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ServiceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseServiceAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServiceAssertion((MessageEvent)event), "universe.ServiceAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ServiceAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseServiceAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationAssertion((MessageEvent)event), "universe.ApplicationAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplicationAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationAssertion((MessageEvent)event), "universe.ApplicationAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplicationAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationAssertion((MessageEvent)event), "universe.ApplicationAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplicationAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseApplicationAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationAssertion((MessageEvent)event), "universe.ApplicationAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplicationAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseApplicationAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationJavaAssertion((MessageEvent)event), "universe.ApplicationJavaAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationJavaAssertion((MessageEvent)event), "universe.ApplicationJavaAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationJavaAssertion((MessageEvent)event), "universe.ApplicationJavaAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationJavaAssertion((MessageEvent)event), "universe.ApplicationJavaAssertion");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("universe.ApplicationJavaAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseApplicationJavaAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Computer(((MessageEvent)event).toMessage()) : (Computer)event, "monitoring.Computer");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Computer", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Computer(((MessageEvent)event).toMessage()) : (Computer)event, "monitoring.Computer");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Computer", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Computer(((MessageEvent)event).toMessage()) : (Computer)event, "monitoring.Computer");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Computer", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringComputerConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Computer(((MessageEvent)event).toMessage()) : (Computer)event, "monitoring.Computer");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Computer", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringComputerConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new CellularGateway(((MessageEvent)event).toMessage()) : (CellularGateway)event, "monitoring.CellularGateway");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.CellularGateway", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new CellularGateway(((MessageEvent)event).toMessage()) : (CellularGateway)event, "monitoring.CellularGateway");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.CellularGateway", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new CellularGateway(((MessageEvent)event).toMessage()) : (CellularGateway)event, "monitoring.CellularGateway");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.CellularGateway", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringCellularGatewayConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new CellularGateway(((MessageEvent)event).toMessage()) : (CellularGateway)event, "monitoring.CellularGateway");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.CellularGateway", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringCellularGatewayConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentFinished((MessageEvent)event), "monitoring.IncidentFinished");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.IncidentFinished", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentFinished((MessageEvent)event), "monitoring.IncidentFinished");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.IncidentFinished", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentFinished((MessageEvent)event), "monitoring.IncidentFinished");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.IncidentFinished", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringIncidentFinishedConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentFinished((MessageEvent)event), "monitoring.IncidentFinished");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.IncidentFinished", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringIncidentFinishedConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(MonitoringIncidentConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Incident((MessageEvent)event), "monitoring.Incident");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Incident", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringIncidentConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Incident((MessageEvent)event), "monitoring.Incident");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Incident", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringIncidentConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Incident((MessageEvent)event), "monitoring.Incident");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Incident", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringIncidentConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Incident((MessageEvent)event), "monitoring.Incident");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Incident", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringIncidentConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Wireless(((MessageEvent)event).toMessage()) : (Wireless)event, "monitoring.Wireless");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Wireless", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Wireless(((MessageEvent)event).toMessage()) : (Wireless)event, "monitoring.Wireless");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Wireless", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Wireless(((MessageEvent)event).toMessage()) : (Wireless)event, "monitoring.Wireless");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Wireless", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringWirelessConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Wireless(((MessageEvent)event).toMessage()) : (Wireless)event, "monitoring.Wireless");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Wireless", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringWirelessConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Switch(((MessageEvent)event).toMessage()) : (Switch)event, "monitoring.Switch");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Switch", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Switch(((MessageEvent)event).toMessage()) : (Switch)event, "monitoring.Switch");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Switch", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Switch(((MessageEvent)event).toMessage()) : (Switch)event, "monitoring.Switch");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Switch", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringSwitchConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Switch(((MessageEvent)event).toMessage()) : (Switch)event, "monitoring.Switch");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Switch", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringSwitchConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Application(((MessageEvent)event).toMessage()) : (Application)event, "monitoring.Application");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Application", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Application(((MessageEvent)event).toMessage()) : (Application)event, "monitoring.Application");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Application", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Application(((MessageEvent)event).toMessage()) : (Application)event, "monitoring.Application");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Application", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringApplicationConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Application(((MessageEvent)event).toMessage()) : (Application)event, "monitoring.Application");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Application", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringApplicationConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(AnalysisAnalysisConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Analysis(((MessageEvent)event).toMessage()) : (Analysis)event, "analysis.Analysis");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("analysis.Analysis", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(AnalysisAnalysisConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Analysis(((MessageEvent)event).toMessage()) : (Analysis)event, "analysis.Analysis");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("analysis.Analysis", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(AnalysisAnalysisConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Analysis(((MessageEvent)event).toMessage()) : (Analysis)event, "analysis.Analysis");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("analysis.Analysis", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(AnalysisAnalysisConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Analysis(((MessageEvent)event).toMessage()) : (Analysis)event, "analysis.Analysis");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("analysis.Analysis", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(AnalysisAnalysisConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Camera(((MessageEvent)event).toMessage()) : (Camera)event, "monitoring.Camera");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Camera", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Camera(((MessageEvent)event).toMessage()) : (Camera)event, "monitoring.Camera");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Camera", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Camera(((MessageEvent)event).toMessage()) : (Camera)event, "monitoring.Camera");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Camera", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringCameraConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Camera(((MessageEvent)event).toMessage()) : (Camera)event, "monitoring.Camera");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Camera", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringCameraConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Status((MessageEvent)event), "monitoring.Status");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Status", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Status((MessageEvent)event), "monitoring.Status");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Status", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Status((MessageEvent)event), "monitoring.Status");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Status", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringStatusConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Status((MessageEvent)event), "monitoring.Status");
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }));
        this.connector.attachListener("monitoring.Status", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringStatusConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(this.connector::detachListeners);
    }

    public synchronized List<MetaMessage> metamodel() {
        Message response = this.connector.requestResponse("service.ness.metamodel", this.request("Metamodel"), 10L, TimeUnit.SECONDS);
        if (response == null) {
            return null;
        }
        try {
            return (List)Json.fromJson(((TextMessage)response).getText(), new TypeToken<ArrayList<MetaMessage>>(this){}.getType());
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    public synchronized void requestSeal() {
        this.connector.requestResponse("service.ness.seal", this.request("Seal"), 30L, TimeUnit.MINUTES);
    }

    public synchronized Instant requestLastSeal() {
        Message message = this.connector.requestResponse("service.ness.seal.last", this.request("LastSeal"), 10L, TimeUnit.MINUTES);
        if (message == null) {
            return Instant.now();
        }
        try {
            return Instant.parse(((TextMessage)message).getText());
        }
        catch (Exception e) {
            Logger.error(e);
            return Instant.now();
        }
    }

    private Message request(String type) {
        return this.request(type, Collections.emptyMap());
    }

    private Message request(String type, Map<String, String> attributes) {
        try {
            ActiveMQTextMessage m = new ActiveMQTextMessage();
            io.intino.alexandria.message.Message message = new io.intino.alexandria.message.Message(type);
            attributes.forEach(message::set);
            m.setText(message.toString());
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addDatamartSubscribers(String sourceSelector) {
        this.addDatamartEventSubscribers(sourceSelector, ts -> ts.isAfter(this.datamart.ts()));
        if (this.datamart.requiresDatahubNotifications()) {
            this.connector.attachListener("service.ness.datamarts.notifications", null, (m, c) -> new Thread(() -> this.manageDatamartMessage(m)).start());
        }
        this.connector.attachListener("service.ness.datamarts", null, (m, c) -> new Thread(() -> this.manageDatamartMessage(m)).start());
    }

    private void addDatamartEventSubscribers(String sourceSelector, Predicate<Instant> predicate) {
        this.datamartConsumers.clear();
        BiConsumer<TagAssertion, String> subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseTagAssertionConsumer)subscriber, this.connector.clientId() + "_master_TagAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniversePlaceAssertionConsumer)subscriber, this.connector.clientId() + "_master_PlaceAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseIncidentRuleAssertionConsumer)subscriber, this.connector.clientId() + "_master_IncidentRuleAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniversePartAssertionConsumer)subscriber, this.connector.clientId() + "_master_PartAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseComputerAssertionConsumer)subscriber, this.connector.clientId() + "_master_ComputerAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseApplicationAssertionConsumer)subscriber, this.connector.clientId() + "_master_ApplicationAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseProcessAssertionConsumer)subscriber, this.connector.clientId() + "_master_ProcessAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseSoftwareAssertionConsumer)subscriber, this.connector.clientId() + "_master_SoftwareAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseObserverAssertionConsumer)subscriber, this.connector.clientId() + "_master_ObserverAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseHardwareAssertionConsumer)subscriber, this.connector.clientId() + "_master_HardwareAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseAreaAssertionConsumer)subscriber, this.connector.clientId() + "_master_AreaAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseCountermeasureAssertionConsumer)subscriber, this.connector.clientId() + "_master_CountermeasureAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseApplianceAssertionConsumer)subscriber, this.connector.clientId() + "_master_ApplianceAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseApplicationJavaAssertionConsumer)subscriber, this.connector.clientId() + "_master_ApplicationJavaAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseModelAssertionConsumer)subscriber, this.connector.clientId() + "_master_ModelAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniversePersonAssertionConsumer)subscriber, this.connector.clientId() + "_master_PersonAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseAssetAssertionConsumer)subscriber, this.connector.clientId() + "_master_AssetAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseOrderTypeAssertionConsumer)subscriber, this.connector.clientId() + "_master_OrderTypeAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseServiceAssertionConsumer)subscriber, this.connector.clientId() + "_master_ServiceAssertion", predicate, sourceSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void manageDatamartMessage(String message) {
        Object object = this.monitor;
        synchronized (object) {
            JsonObject jsonObject = Json.fromJson(message, JsonObject.class);
            String operation = jsonObject.getAsJsonPrimitive("operation").getAsString();
            if (operation.equals("reload")) {
                this.datamartConsumers.forEach(c -> this.consumers.get(c).forEach(this.connector::detachListeners));
                this.datamart.init(this.sourceSelector);
                this.addDatamartEventSubscribers(this.sourceSelector, ts -> ts.isAfter(this.datamart.ts()));
            } else if (operation.equals("refresh")) {
                jsonObject.get("changes").getAsJsonArray().asList().stream().map(e -> e.getAsString()).forEach(this.datamart::handleDatahubNotification);
            }
        }
    }

    private String channelOf(String type) {
        return switch (type) {
            case "Status" -> "monitoring.Status";
            case "Incident" -> "monitoring.Incident";
            case "IncidentFinished" -> "monitoring.IncidentFinished";
            case "PlaceAssertion" -> "universe.PlaceAssertion";
            case "AreaAssertion" -> "universe.AreaAssertion";
            case "ModelAssertion" -> "universe.ModelAssertion";
            case "OrderTypeAssertion" -> "universe.OrderTypeAssertion";
            case "PersonAssertion" -> "universe.PersonAssertion";
            case "ProcessAssertion" -> "universe.ProcessAssertion";
            case "AssetAssertion" -> "universe.AssetAssertion";
            case "PartAssertion" -> "universe.PartAssertion";
            case "HardwareAssertion" -> "universe.HardwareAssertion";
            case "ComputerAssertion" -> "universe.ComputerAssertion";
            case "ApplianceAssertion" -> "universe.ApplianceAssertion";
            case "SoftwareAssertion" -> "universe.SoftwareAssertion";
            case "ObserverAssertion" -> "universe.ObserverAssertion";
            case "ApplicationAssertion" -> "universe.ApplicationAssertion";
            case "ApplicationJavaAssertion" -> "universe.ApplicationJavaAssertion";
            case "ServiceAssertion" -> "universe.ServiceAssertion";
            case "Computer" -> "monitoring.Computer";
            case "Application" -> "monitoring.Application";
            case "Camera" -> "monitoring.Camera";
            case "CellularGateway" -> "monitoring.CellularGateway";
            case "Switch" -> "monitoring.Switch";
            case "Wireless" -> "monitoring.Wireless";
            case "Log" -> "monitoring.Log";
            default -> null;
        };
    }

    public static class DatamartsRetryConfig {
        public final long initialTimeoutAmount;
        public final TimeUnit timeoutUnit;
        public final float timeoutMultiplier;
        public final int maxAttempts;

        public DatamartsRetryConfig() {
            this(1L, TimeUnit.MINUTES, 2.0f, 5);
        }

        public DatamartsRetryConfig(long initialTimeoutAmount, TimeUnit timeoutUnit, float timeoutMultiplier, int maxAttempts) {
            this.initialTimeoutAmount = initialTimeoutAmount;
            this.timeoutUnit = timeoutUnit;
            this.timeoutMultiplier = timeoutMultiplier;
            this.maxAttempts = maxAttempts;
        }
    }

    public class BatchSession {
        private final File temporalStage;
        private final SessionHandler sessionHandler;
        private final EventSession session;
        private final Scale scale;

        public BatchSession(File temporalStage) {
            this(temporalStage, new Config());
        }

        public BatchSession(File temporalStage, Config config) {
            this.temporalStage = temporalStage;
            this.scale = config.scale;
            this.sessionHandler = new SessionHandler(temporalStage);
            this.session = this.sessionHandler.createEventSession(config.eventsBufferSize);
        }

        public void feed(Event event) throws IOException {
            this.session.put(this.tankOf(event), event.ss(), Timetag.of(event.ts(), this.scale), event.format(), event);
        }

        public void feed(Event event, Scale scale) throws IOException {
            this.session.put(this.tankOf(event), event.ss(), Timetag.of(event.ts(), scale), event.format(), event);
        }

        public void flush() {
            this.session.flush();
        }

        public void push(File dataHubStage) {
            this.session.close();
            this.sessionHandler.pushTo(dataHubStage);
        }

        public void push(String host, String user, String dataHubStageAbsolutePath) {
            this.session.close();
            try {
                List<File> files = BatchSession.allFilesIn(this.temporalStage.toPath(), path -> path.getName().endsWith(".session")).collect(Collectors.toList());
                this.upload(files, host, user, dataHubStageAbsolutePath);
                this.temporalStage.renameTo(new File(this.temporalStage.getParentFile(), this.temporalStage.getName() + ".treated"));
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }

        private static Stream<File> allFilesIn(Path path, Predicate<File> filter) throws Exception {
            Stream.Builder streamBuilder = Stream.builder();
            try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
                paths.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && filter.test(p.toFile())).forEach(p -> streamBuilder.add(p.toFile()));
            }
            return streamBuilder.build();
        }

        public synchronized void seal() {
            ObserverTerminal.this.connector.requestResponse("service.ness.seal", ObserverTerminal.this.request("Seal", Map.of("stage", this.temporalStage.getName())));
        }

        private void upload(List<File> sessions, String host, String user, String dataHubStageAbsolutePath) {
            try {
                String connectionChain = user + "@" + host + ":" + dataHubStageAbsolutePath;
                Logger.info("Uploading sessions to " + connectionChain + "...");
                for (File s : sessions) {
                    Process process = new ProcessBuilder("scp", s.getAbsolutePath(), connectionChain).inheritIO().start();
                    process.waitFor(1L, TimeUnit.HOURS);
                }
                Logger.info("sessions uploaded");
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }

        private String tankOf(Event event) {
            if (event instanceof Status) {
                return "monitoring.Status";
            }
            if (event instanceof Incident) {
                return "monitoring.Incident";
            }
            if (event instanceof IncidentFinished) {
                return "monitoring.IncidentFinished";
            }
            if (event instanceof PlaceAssertion) {
                return "universe.PlaceAssertion";
            }
            if (event instanceof AreaAssertion) {
                return "universe.AreaAssertion";
            }
            if (event instanceof ModelAssertion) {
                return "universe.ModelAssertion";
            }
            if (event instanceof OrderTypeAssertion) {
                return "universe.OrderTypeAssertion";
            }
            if (event instanceof PersonAssertion) {
                return "universe.PersonAssertion";
            }
            if (event instanceof ProcessAssertion) {
                return "universe.ProcessAssertion";
            }
            if (event instanceof AssetAssertion) {
                return "universe.AssetAssertion";
            }
            if (event instanceof PartAssertion) {
                return "universe.PartAssertion";
            }
            if (event instanceof HardwareAssertion) {
                return "universe.HardwareAssertion";
            }
            if (event instanceof ComputerAssertion) {
                return "universe.ComputerAssertion";
            }
            if (event instanceof ApplianceAssertion) {
                return "universe.ApplianceAssertion";
            }
            if (event instanceof SoftwareAssertion) {
                return "universe.SoftwareAssertion";
            }
            if (event instanceof ObserverAssertion) {
                return "universe.ObserverAssertion";
            }
            if (event instanceof ApplicationAssertion) {
                return "universe.ApplicationAssertion";
            }
            if (event instanceof ApplicationJavaAssertion) {
                return "universe.ApplicationJavaAssertion";
            }
            if (event instanceof ServiceAssertion) {
                return "universe.ServiceAssertion";
            }
            if (event instanceof Computer) {
                return "monitoring.Computer";
            }
            if (event instanceof Application) {
                return "monitoring.Application";
            }
            if (event instanceof Camera) {
                return "monitoring.Camera";
            }
            if (event instanceof CellularGateway) {
                return "monitoring.CellularGateway";
            }
            if (event instanceof Switch) {
                return "monitoring.Switch";
            }
            if (event instanceof Wireless) {
                return "monitoring.Wireless";
            }
            if (event instanceof Log) {
                return "monitoring.Log";
            }
            return event.type();
        }
    }

    public static class Config {
        private int eventsBufferSize = 1000000;
        private int setsBufferSize = 1000000;
        private Scale scale = Scale.Day;

        public Config scale(Scale scale) {
            this.scale = scale;
            return this;
        }

        public Config eventsBufferSize(int eventsBufferSize) {
            this.eventsBufferSize = eventsBufferSize;
            return this;
        }

        public Config setsBufferSize(int setsBufferSize) {
            this.setsBufferSize = setsBufferSize;
            return this;
        }
    }

    public static interface UniversePlaceAssertionConsumer
    extends BiConsumer<PlaceAssertion, String> {
    }

    public static interface UniverseAreaAssertionConsumer
    extends BiConsumer<AreaAssertion, String> {
    }

    public static interface UniverseTagAssertionConsumer
    extends BiConsumer<TagAssertion, String> {
    }

    public static interface UniverseIncidentRuleAssertionConsumer
    extends BiConsumer<IncidentRuleAssertion, String> {
    }

    public static interface UniverseCountermeasureAssertionConsumer
    extends BiConsumer<CountermeasureAssertion, String> {
    }

    public static interface UniverseModelAssertionConsumer
    extends BiConsumer<ModelAssertion, String> {
    }

    public static interface UniverseOrderTypeAssertionConsumer
    extends BiConsumer<OrderTypeAssertion, String> {
    }

    public static interface UniversePersonAssertionConsumer
    extends BiConsumer<PersonAssertion, String> {
    }

    public static interface UniverseProcessAssertionConsumer
    extends BiConsumer<ProcessAssertion, String> {
    }

    public static interface UniverseAssetAssertionConsumer
    extends BiConsumer<AssetAssertion, String> {
    }

    public static interface UniversePartAssertionConsumer
    extends BiConsumer<PartAssertion, String> {
    }

    public static interface UniverseHardwareAssertionConsumer
    extends BiConsumer<HardwareAssertion, String> {
    }

    public static interface UniverseApplianceAssertionConsumer
    extends BiConsumer<ApplianceAssertion, String> {
    }

    public static interface UniverseComputerAssertionConsumer
    extends BiConsumer<ComputerAssertion, String> {
    }

    public static interface UniverseSoftwareAssertionConsumer
    extends BiConsumer<SoftwareAssertion, String> {
    }

    public static interface UniverseObserverAssertionConsumer
    extends BiConsumer<ObserverAssertion, String> {
    }

    public static interface UniverseServiceAssertionConsumer
    extends BiConsumer<ServiceAssertion, String> {
    }

    public static interface UniverseApplicationAssertionConsumer
    extends BiConsumer<ApplicationAssertion, String> {
    }

    public static interface UniverseApplicationJavaAssertionConsumer
    extends BiConsumer<ApplicationJavaAssertion, String> {
    }

    public static interface MonitoringComputerConsumer
    extends BiConsumer<Computer, String> {
    }

    public static interface MonitoringCellularGatewayConsumer
    extends BiConsumer<CellularGateway, String> {
    }

    public static interface MonitoringIncidentFinishedConsumer
    extends BiConsumer<IncidentFinished, String> {
    }

    public static interface MonitoringIncidentConsumer
    extends BiConsumer<Incident, String> {
    }

    public static interface MonitoringWirelessConsumer
    extends BiConsumer<Wireless, String> {
    }

    public static interface MonitoringSwitchConsumer
    extends BiConsumer<Switch, String> {
    }

    public static interface MonitoringApplicationConsumer
    extends BiConsumer<Application, String> {
    }

    public static interface AnalysisAnalysisConsumer
    extends BiConsumer<Analysis, String> {
    }

    public static interface MonitoringCameraConsumer
    extends BiConsumer<Camera, String> {
    }

    public static interface MonitoringStatusConsumer
    extends BiConsumer<Status, String> {
    }

    public static interface MonitoringLogConsumer
    extends BiConsumer<Log, String> {
    }

    public record MetaAttribute(String name, String type) {
    }

    public record MetaMessage(String name, boolean assertion, boolean multiple, List<MetaAttribute> attributes, List<MetaMessage> components, List<String> hierarchy) {
    }
}

