/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.framework.Activity;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.Message;
import java.util.Map;

public class FactoryResetRequest
implements RequestAttendant {
    public static final String ID = "factoryReset";
    private final ContainerBox box;
    private final ContainerStore store;

    public FactoryResetRequest(ContainerBox box, Activity.Context context, ContainerStore store) {
        this.box = box;
        this.store = store;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message message) {
        try {
            Logger.info("Factory reset requested...");
            Map<String, Boolean> activities = this.box.activities().activities();
            Activity.Result allUninstalled = activities.keySet().stream().map(k -> this.uninstall(activities, (String)k)).reduce((a1, a2) -> !a1.success() ? a1 : a2).orElse(new Activity.Result(false, ""));
            if (allUninstalled.success()) {
                this.store.clear();
                this.store.save();
                Logger.info("Factory reset done");
            } else {
                Logger.warn("Impossible to uninstall all activities");
            }
            return new RequestAttendant.RequestResult(allUninstalled.success(), "Factory reset done");
        }
        catch (Throwable e) {
            Logger.error(e);
            return new RequestAttendant.RequestResult(false, e.getMessage());
        }
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }

    private Activity.Result uninstall(Map<String, Boolean> activities, String k) {
        Activity.Result uninstalled;
        if (activities.get(k).booleanValue()) {
            this.box.activities().disableActivity(k);
        }
        if (!(uninstalled = this.box.activities().uninstallActivity(k)).success()) {
            Logger.warn("Impossible to uninstall " + k);
        }
        return uninstalled;
    }
}

