/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.model.Info;
import io.intino.consul.framework.Activity;
import io.intino.cosmos.datahub.messages.monitoring.Status;
import io.intino.cosmos.datahub.messages.universe.ComputerAssertion;
import java.io.BufferedReader;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class ComputerAssertionAction {
    public static final String ONLINE_SIGNAL = "online";
    public ContainerBox box;
    private Activity.Context context;

    public void execute() {
        try {
            this.doExecute();
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }

    private void doExecute() {
        this.context = this.box.context();
        ComputerAssertion newInfo = this.computerInfo();
        if (newInfo == null) {
            return;
        }
        Info last = this.last();
        if (!this.hasChanges(last, newInfo)) {
            return;
        }
        if (this.context.terminal() != null) {
            this.sleep(1000);
            this.context.terminal().publish(newInfo);
        }
        if (last == null && this.context.terminal() != null) {
            this.context.terminal().publish(this.status(List.of(ONLINE_SIGNAL)));
        }
        this.box.store().put("info", this.map(newInfo));
    }

    private Status status(List<String> signals) {
        return new Status(this.context.observer()).observable(this.context.hostName()).group(ONLINE_SIGNAL).signals(signals);
    }

    private boolean hasChanges(Info last, ComputerAssertion newInfo) {
        return last == null || !Objects.equals(last.name(), newInfo.id()) || last.diskSize() != newInfo.diskSize().longValue() || last.memorySize() != newInfo.memorySize().longValue() || last.maxOpenFiles() != newInfo.maxOpenFiles().longValue() || !last.localIps().equals(newInfo.ip()) || !Objects.equals(last.publicIp(), newInfo.publicIp()) || !Objects.equals(newInfo.jvm(), last.jvm());
    }

    private Info last() {
        return this.box.store().get("info", Info.class);
    }

    private void sleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException e) {
            Logger.error(e);
        }
    }

    private Info map(ComputerAssertion newInfo) {
        return new Info(newInfo.id(), newInfo.ip(), newInfo.publicIp(), newInfo.cores(), newInfo.diskSize(), newInfo.memorySize(), newInfo.maxOpenFiles(), newInfo.jvm());
    }

    private ComputerAssertion computerInfo() {
        Activity.System system = this.context.system();
        String name = system.name();
        if (name == null || name.isEmpty()) {
            return null;
        }
        Activity.System.Network network = system.network();
        Activity.System.HDD hdd = system.hdd();
        String osName = ComputerAssertionAction.osName(system);
        return (ComputerAssertion)new ComputerAssertion(this.context.observer() + "." + name, name).ts(Instant.now()).isp(network.ISP()).os(osName).maxOpenFiles(hdd.maxOpenFiles()).cores(system.cpu().cores()).diskSize(hdd.capacityMB()).memorySize(system.ram().capacityMB()).architecture(System.getProperty("os.arch")).jvm(this.findInstalledJVM()).publicIp(network.publicIP()).ip(List.of(network.localIP())).observer(this.box.observer());
    }

    private static String osName(Activity.System system) {
        try {
            return system.operatingSystem().name();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String findInstalledJVM() {
        try {
            Process java = new ProcessBuilder("java", "--version").start();
            Thread.sleep(1000L);
            BufferedReader reader = java.inputReader();
            List<String> lines = reader.lines().toList();
            reader.close();
            if (!lines.isEmpty()) {
                return lines.get(0);
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.error(e);
        }
        return null;
    }
}

