/*
 * Decompiled with CFR 0.152.
 */
package smile.vq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import smile.sort.HeapSelect;
import smile.vq.VectorQuantizer;
import smile.vq.hebb.Edge;
import smile.vq.hebb.Neuron;

public class NeuralMap
implements VectorQuantizer {
    private static final long serialVersionUID = 2L;
    private int t = 0;
    private final double r;
    private final int edgeLifetime;
    private final double epsBest;
    private final double epsNeighbor;
    private final double beta;
    private final ArrayList<Neuron> neurons = new ArrayList();
    private final Neuron[] top2 = new Neuron[2];

    public NeuralMap(double r, double epsBest, double epsNeighbor, int edgeLifetime, double beta) {
        this.r = r;
        this.epsBest = epsBest;
        this.epsNeighbor = epsNeighbor;
        this.edgeLifetime = edgeLifetime;
        this.beta = beta;
    }

    @Override
    public void update(double[] x) {
        Neuron neighbor;
        ++this.t;
        if (this.neurons.size() < 2) {
            this.neurons.add(new Neuron((double[])x.clone()));
            return;
        }
        ((Stream)this.neurons.stream().parallel()).forEach(neuron -> neuron.distance(x));
        Arrays.fill(this.top2, null);
        HeapSelect heap = new HeapSelect((Comparable[])this.top2);
        for (Neuron neuron2 : this.neurons) {
            heap.add(neuron2);
        }
        Neuron s1 = this.top2[1];
        Neuron s2 = this.top2[0];
        if (s1.distance > this.r) {
            Neuron neuron3 = new Neuron((double[])x.clone());
            this.neurons.add(neuron3);
            return;
        }
        if (s2.distance > this.r) {
            Neuron neuron4 = new Neuron((double[])x.clone());
            this.neurons.add(neuron4);
            s1.addEdge(neuron4);
            neuron4.addEdge(s1);
            return;
        }
        s1.update(x, this.epsBest);
        s1.counter += 1.0;
        s1.age();
        boolean addEdge = true;
        for (Edge edge : s1.edges) {
            neighbor = edge.neighbor;
            neighbor.update(x, this.epsNeighbor);
            if (neighbor != s2) continue;
            edge.age = 0;
            s2.setEdgeAge(s1, 0);
            addEdge = false;
        }
        if (addEdge) {
            s1.addEdge(s2);
            s2.addEdge(s1);
            s2.update(x, this.epsNeighbor);
        }
        Iterator<Edge> iter = s1.edges.iterator();
        while (iter.hasNext()) {
            Edge edge;
            edge = iter.next();
            if (edge.age <= this.edgeLifetime) continue;
            iter.remove();
            neighbor = edge.neighbor;
            neighbor.removeEdge(s1);
            if (!neighbor.edges.isEmpty()) continue;
            this.neurons.removeIf(neuron -> neuron == edge.neighbor);
        }
        for (Neuron neuron5 : this.neurons) {
            neuron5.counter *= this.beta;
        }
    }

    public Neuron[] neurons() {
        return this.neurons.toArray(new Neuron[0]);
    }

    public void clear(double eps) {
        ArrayList<Neuron> noise = new ArrayList<Neuron>();
        for (Neuron neuron : this.neurons) {
            if (neuron.counter < eps) {
                for (Edge edge : neuron.edges) {
                    edge.neighbor.removeEdge(neuron);
                }
                neuron.edges.clear();
            } else {
                Iterator<Edge> iter = neuron.edges.iterator();
                while (iter.hasNext()) {
                    Edge edge;
                    edge = iter.next();
                    if (edge.age <= this.edgeLifetime) continue;
                    edge.neighbor.removeEdge(neuron);
                    iter.remove();
                }
            }
            if (!neuron.edges.isEmpty()) continue;
            noise.add(neuron);
        }
        this.neurons.removeAll(noise);
    }

    @Override
    public double[] quantize(double[] x) {
        ((Stream)this.neurons.stream().parallel()).forEach(node -> node.distance(x));
        Neuron bmu = this.neurons.get(0);
        for (Neuron neuron : this.neurons) {
            if (!(neuron.distance < bmu.distance)) continue;
            bmu = neuron;
        }
        return bmu.w;
    }
}

