/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.imputation;

import smile.clustering.CLARANS;
import smile.data.AbstractTuple;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.transform.Transform;
import smile.data.type.StructType;
import smile.feature.imputation.SimpleImputer;
import smile.math.distance.Distance;

public class KMedoidsImputer
implements Transform {
    private final CLARANS<Tuple> kmedoids;

    public KMedoidsImputer(CLARANS<Tuple> kmedoids) {
        this.kmedoids = kmedoids;
    }

    @Override
    public Tuple apply(final Tuple x) {
        if (!SimpleImputer.hasMissing(x)) {
            return x;
        }
        final StructType schema = x.schema();
        final Tuple medioid = ((Tuple[])this.kmedoids.centroids)[this.kmedoids.predict(x)];
        return new AbstractTuple(){

            @Override
            public Object get(int i) {
                Object xi = x.get(i);
                return SimpleImputer.isMissing(xi) ? medioid.get(i) : xi;
            }

            @Override
            public StructType schema() {
                return schema;
            }
        };
    }

    public static KMedoidsImputer fit(DataFrame data, Distance<Tuple> distance, int k) {
        Tuple[] tuples = new Tuple[data.size()];
        for (int i = 0; i < tuples.length; ++i) {
            tuples[i] = (Tuple)data.get(i);
        }
        CLARANS<Tuple> kmedoids = CLARANS.fit(tuples, distance, k);
        return new KMedoidsImputer(kmedoids);
    }
}

