/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import java.util.ArrayList;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.fitting.AbstractCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import ro.hasna.ts.math.exception.ArrayLengthIsTooSmallException;
import ro.hasna.ts.math.representation.GenericTransformer;
import ro.hasna.ts.math.util.TimeSeriesPrecision;

public class PiecewiseCurveFitterApproximation
implements GenericTransformer<double[], double[][]> {
    private static final long serialVersionUID = -410430777798956046L;
    private final int segments;
    private final AbstractCurveFitter curveFitter;

    public PiecewiseCurveFitterApproximation(int segments, AbstractCurveFitter curveFitter) {
        if (segments < 1) {
            throw new NumberIsTooSmallException(segments, (Number)1, true);
        }
        this.segments = segments;
        this.curveFitter = curveFitter;
    }

    @Override
    public double[][] transform(double[] values) {
        int len = values.length;
        if (len < this.segments) {
            throw new ArrayLengthIsTooSmallException(len, (Number)this.segments, true);
        }
        int modulo = len % this.segments;
        double[][] reducedValues = new double[this.segments][];
        if (modulo == 0) {
            int segmentSize = len / this.segments;
            ArrayList<WeightedObservedPoint> segment = new ArrayList<WeightedObservedPoint>(segmentSize);
            for (int i = 0; i < segmentSize; ++i) {
                segment.add(null);
            }
            int n = 0;
            for (int i = 0; i < len; ++i) {
                int index = i % segmentSize;
                segment.set(index, new WeightedObservedPoint(1.0, index, values[i]));
                if (index + 1 != segmentSize) continue;
                reducedValues[n++] = this.curveFitter.fit(segment);
                if (n != this.segments) {
                    continue;
                }
                break;
            }
        } else {
            double segmentSize = (double)len * 1.0 / (double)this.segments;
            int k = 0;
            int segmentSizeReal = (int)FastMath.ceil(segmentSize) + 1;
            int index = 0;
            ArrayList<WeightedObservedPoint> segment = new ArrayList<WeightedObservedPoint>(segmentSizeReal);
            for (int i = 0; i < this.segments - 1; ++i) {
                double x = (double)(i + 1) * segmentSize - 1.0;
                while ((double)k < x) {
                    segment.add(new WeightedObservedPoint(1.0, index, values[k]));
                    ++index;
                    ++k;
                }
                double delta = x - (double)((int)x);
                if (!Precision.equals(delta, 0.0, TimeSeriesPrecision.EPSILON)) {
                    segment.add(new WeightedObservedPoint(delta, index, values[k]));
                }
                reducedValues[i] = this.curveFitter.fit(segment);
                segment = new ArrayList(segmentSizeReal);
                index = 0;
                if (!Precision.equals(delta, 1.0, TimeSeriesPrecision.EPSILON)) {
                    segment.add(new WeightedObservedPoint(1.0 - delta, index, values[k]));
                    ++index;
                }
                ++k;
            }
            while (k < len) {
                segment.add(new WeightedObservedPoint(1.0, index, values[k]));
                ++index;
                ++k;
            }
            reducedValues[this.segments - 1] = this.curveFitter.fit(segment);
        }
        return reducedValues;
    }

    public int getSegments() {
        return this.segments;
    }
}

