/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.Precision;
import ro.hasna.ts.math.ml.distance.EuclideanDistanceAdapter;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;
import ro.hasna.ts.math.util.TimeSeriesPrecision;

public class UniformScalingDistance
implements GenericDistanceMeasure<double[]> {
    private static final long serialVersionUID = -596315329786672046L;
    private final double minScalingFactor;
    private final double maxScalingFactor;
    private final int steps;
    private final GenericDistanceMeasure<double[]> distance;

    public UniformScalingDistance(double minScalingFactor, double maxScalingFactor, int steps) {
        this(minScalingFactor, maxScalingFactor, steps, new EuclideanDistanceAdapter());
    }

    public UniformScalingDistance(double minScalingFactor, double maxScalingFactor, int steps, GenericDistanceMeasure<double[]> distance) {
        if (minScalingFactor <= 0.0) {
            throw new NumberIsTooSmallException(minScalingFactor, (Number)0, false);
        }
        this.minScalingFactor = minScalingFactor;
        if (maxScalingFactor < minScalingFactor) {
            throw new NumberIsTooSmallException(maxScalingFactor, (Number)minScalingFactor, true);
        }
        this.maxScalingFactor = maxScalingFactor;
        if (steps < 1) {
            throw new NumberIsTooSmallException(steps, (Number)1, true);
        }
        this.steps = steps;
        this.distance = distance;
    }

    @Override
    public double compute(double[] a, double[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(double[] a, double[] b, double cutOffValue) {
        double min = Double.POSITIVE_INFINITY;
        double[] aux = new double[a.length];
        if (this.steps == 1) {
            double scalingFactor = (this.minScalingFactor + this.maxScalingFactor) / 2.0;
            return this.computeDistance(a, b, aux, scalingFactor, cutOffValue);
        }
        double interval = (this.maxScalingFactor - this.minScalingFactor) / (double)(this.steps - 1);
        if (Precision.equals(interval, 0.0, TimeSeriesPrecision.EPSILON)) {
            return this.computeDistance(a, b, aux, this.minScalingFactor, cutOffValue);
        }
        for (double i = this.minScalingFactor; i <= this.maxScalingFactor; i += interval) {
            double d = this.computeDistance(a, b, aux, i, cutOffValue);
            if (!(d < min) || !Precision.equals(min = d, 0.0, TimeSeriesPrecision.EPSILON)) continue;
            return min;
        }
        return min;
    }

    private double computeDistance(double[] a, double[] b, double[] aux, double scalingFactor, double cutOffValue) {
        if (Precision.equals(scalingFactor, 1.0, TimeSeriesPrecision.EPSILON)) {
            return this.distance.compute(a, b, cutOffValue);
        }
        if (scalingFactor > 1.0) {
            return this.computeDistance(b, a, aux, 1.0 / scalingFactor, cutOffValue);
        }
        int n = a.length;
        aux[0] = b[0];
        for (int i = 1; i < n; ++i) {
            double j = (double)i * scalingFactor;
            int k = (int)j;
            aux[i] = Precision.equals(j, (double)k, TimeSeriesPrecision.EPSILON) ? b[k] : (b[k + 1] - b[k]) * j + (double)(k + 1) * b[k] - (double)k * b[k + 1];
        }
        return this.distance.compute(a, aux, cutOffValue);
    }
}

