/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master;

import io.intino.ness.master.model.Entity;
import io.intino.ness.master.reflection.DatamartDefinition;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Datamart {
    default public String name() {
        return this.getDefinition().name();
    }

    default public Scale scale() {
        return this.getDefinition().scale();
    }

    public int size();

    public <T extends Entity> T get(String var1);

    public Stream<Entity> entities();

    default public Map<String, Entity> toMap() {
        return this.entities().collect(Collectors.toMap(Entity::id, Function.identity()));
    }

    public void addEntityListener(EntityListener var1);

    public DatamartDefinition getDefinition();

    public Dictionary dictionary();

    public static enum Scale {
        Year,
        Month,
        Week,
        Day,
        None;

    }

    public static interface Dictionary {
        public Word get(String var1);

        public Stream<Word> words();

        public Set<String> languages();

        public static interface Word {
            public String get();

            public Set<String> languages();

            public Optional<String> in(String var1);

            public static Word wrap(final String word) {
                return new Word(){

                    @Override
                    public String get() {
                        return word;
                    }

                    @Override
                    public Set<String> languages() {
                        return Collections.emptySet();
                    }

                    @Override
                    public Optional<String> in(String language) {
                        return Optional.empty();
                    }
                };
            }
        }
    }

    public static interface EntityListener {
        public void onCreate(Entity var1);

        public void onUpdate(Entity var1);

        public void onRemove(Entity var1);

        public static interface OnRemove
        extends EntityListener {
            @Override
            default public void onCreate(Entity entity) {
            }

            @Override
            default public void onUpdate(Entity entity) {
            }
        }

        public static interface OnUpdate
        extends EntityListener {
            @Override
            default public void onCreate(Entity entity) {
            }

            @Override
            default public void onRemove(Entity entity) {
            }
        }

        public static interface OnCreate
        extends EntityListener {
            @Override
            default public void onUpdate(Entity entity) {
            }

            @Override
            default public void onRemove(Entity entity) {
            }
        }
    }
}

