/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ModelAssertion
extends MessageEvent
implements Serializable {
    private List<Profile> profileList = null;

    public ModelAssertion(String ss, String id) {
        this(new MessageEvent("ModelAssertion", ss).toMessage(), id);
    }

    public ModelAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public ModelAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private ModelAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public ModelAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public ModelAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    public ModelAssertion enabled(boolean enabled) {
        this.message.set("enabled", enabled);
        return this;
    }

    public static ModelAssertion fromString(String event) {
        return new ModelAssertion(new MessageReader(event).next());
    }

    @Override
    public String type() {
        return !this.message.contains("type") ? null : this.message.get("type").asString();
    }

    public Profile profile() {
        List<Message> components = this.message.components("Profile");
        return components.isEmpty() ? null : new Profile(components.get(0));
    }

    public ModelAssertion type(String type) {
        if (type == null) {
            this.message.remove("type");
        } else {
            this.message.set("type", type);
        }
        return this;
    }

    public ModelAssertion profile(Profile profile) {
        this.message.components("Profile").forEach(v -> this.message.remove((Message)v));
        if (profile != null) {
            this.message.add(profile.toMessage());
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static class Profile
    implements Serializable {
        private List<Variable> variableList = null;
        protected Message message;

        public Profile() {
            this.message = new Message("Profile");
        }

        public Profile(Message message) {
            this.message = message;
        }

        public List<Variable> variableList() {
            if (this.variableList != null) {
                return this.variableList;
            }
            this.variableList = new ArrayList<Variable>((Collection)this.message.components("Variable").stream().map(c -> new Variable((Message)c)).collect(Collectors.toList())){

                @Override
                public boolean add(Variable element) {
                    super.add(element);
                    message.add(element.toMessage());
                    return true;
                }

                @Override
                public void add(int index, Variable element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Variable)) {
                        return false;
                    }
                    super.remove(o);
                    message.remove(((Variable)o).toMessage());
                    return true;
                }

                @Override
                public Variable remove(int index) {
                    Variable type = (Variable)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super Variable> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Variable)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends Variable> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends Variable> c) {
                    throw new UnsupportedOperationException();
                }
            };
            return this.variableList;
        }

        public Profile variableList(List<Variable> variable) {
            new ArrayList<Variable>(this.variableList()).forEach((Consumer<Variable>)((Consumer<Object>)v -> this.variableList.remove(v)));
            this.variableList.addAll(variable);
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static class Variable
        implements Serializable {
            protected Message message;

            public Variable() {
                this.message = new Message("Variable");
            }

            public Variable(Message message) {
                this.message = message;
            }

            public String name() {
                return !this.message.contains("name") ? null : this.message.get("name").asString();
            }

            public String className() {
                return !this.message.contains("className") ? null : this.message.get("className").asString();
            }

            public String label() {
                return !this.message.contains("label") ? null : this.message.get("label").asString();
            }

            public String type() {
                return !this.message.contains("type") ? null : this.message.get("type").asString();
            }

            public String operator() {
                return !this.message.contains("operator") ? null : this.message.get("operator").asString();
            }

            public String unit() {
                return !this.message.contains("unit") ? null : this.message.get("unit").asString();
            }

            public String symbol() {
                return !this.message.contains("symbol") ? null : this.message.get("symbol").asString();
            }

            public Integer priority() {
                return this.message.get("priority").asInteger();
            }

            public List<String> values() {
                return new ArrayList<String>(this.message.contains("values") ? Arrays.asList(this.message.get("values").as(String[].class)) : Collections.emptyList()){

                    @Override
                    public boolean add(String value) {
                        super.add(value);
                        message.append("values", value);
                        return true;
                    }

                    @Override
                    public void add(int index, String element) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean remove(Object value) {
                        if (!(value instanceof String)) {
                            return false;
                        }
                        super.remove(value);
                        message.remove("values", value);
                        return true;
                    }

                    @Override
                    public String remove(int index) {
                        String type = (String)this.get(index);
                        this.remove(type);
                        return type;
                    }

                    @Override
                    public boolean removeIf(Predicate<? super String> filter) {
                        return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                    }

                    @Override
                    public boolean removeAll(Collection<?> c) {
                        c.forEach(this::remove);
                        return true;
                    }

                    @Override
                    public boolean addAll(Collection<? extends String> c) {
                        c.forEach(this::add);
                        return true;
                    }

                    @Override
                    public boolean addAll(int index, Collection<? extends String> c) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void clear() {
                        super.clear();
                        message.remove("values");
                    }
                };
            }

            public String min() {
                return !this.message.contains("min") ? null : this.message.get("min").asString();
            }

            public String max() {
                return !this.message.contains("max") ? null : this.message.get("max").asString();
            }

            public String description() {
                return !this.message.contains("description") ? null : this.message.get("description").asString();
            }

            public String format() {
                return !this.message.contains("format") ? null : this.message.get("format").asString();
            }

            public Variable name(String name) {
                if (name == null) {
                    this.message.remove("name");
                } else {
                    this.message.set("name", name);
                }
                return this;
            }

            public Variable className(String className) {
                if (className == null) {
                    this.message.remove("className");
                } else {
                    this.message.set("className", className);
                }
                return this;
            }

            public Variable label(String label) {
                if (label == null) {
                    this.message.remove("label");
                } else {
                    this.message.set("label", label);
                }
                return this;
            }

            public Variable type(String type) {
                if (type == null) {
                    this.message.remove("type");
                } else {
                    this.message.set("type", type);
                }
                return this;
            }

            public Variable operator(String operator) {
                if (operator == null) {
                    this.message.remove("operator");
                } else {
                    this.message.set("operator", operator);
                }
                return this;
            }

            public Variable unit(String unit) {
                if (unit == null) {
                    this.message.remove("unit");
                } else {
                    this.message.set("unit", unit);
                }
                return this;
            }

            public Variable symbol(String symbol) {
                if (symbol == null) {
                    this.message.remove("symbol");
                } else {
                    this.message.set("symbol", symbol);
                }
                return this;
            }

            public Variable priority(Integer priority) {
                this.message.set("priority", priority);
                return this;
            }

            public Variable values(List<String> values) {
                this.message.set("values", values);
                return this;
            }

            public Variable min(String min) {
                if (min == null) {
                    this.message.remove("min");
                } else {
                    this.message.set("min", min);
                }
                return this;
            }

            public Variable max(String max) {
                if (max == null) {
                    this.message.remove("max");
                } else {
                    this.message.set("max", max);
                }
                return this;
            }

            public Variable description(String description) {
                if (description == null) {
                    this.message.remove("description");
                } else {
                    this.message.set("description", description);
                }
                return this;
            }

            public Variable format(String format) {
                if (format == null) {
                    this.message.remove("format");
                } else {
                    this.message.set("format", format);
                }
                return this;
            }

            public Message toMessage() {
                return this.message;
            }
        }
    }
}

